package com.atlassian.bitbucket.audit;

import com.atlassian.bitbucket.event.annotation.Audited;

/**
 * The priority levels at which audit events can be raised. Lower levels are filtered out first by consumers.
 * {@link #NONE} can be used to cancel an inherited {@link Audited &#064;Audited} annotation
 */
public enum Priority {

    HIGH(1000),
    MEDIUM(700),
    LOW(300),
    NONE(0);

    private int weight;

    Priority(int weightToAdd) {
        weight = weightToAdd;
    }

    /**
     * Retrieves the weight of this priority relative to other priorities. When filtering, higher weighted priorities
     * will be filtered last.
     *
     * @return the weight of this priority
     */
    public int getWeight() {
        return weight;
    }
}
