package com.atlassian.bitbucket.audit;

/**
 * Represents the set of built-in audit log channel names. Listeners may use the channels to determine whether
 * they are interested in the event.
 */
public class Channels {

    /**
     * Used to notify listeners that the event should be displayed in the audit UI for a project.
     */
    public static final String PROJECT_UI = "audit.channel.ui.project";
    /**
     * Used to notify listeners that the event should be displayed in the audit UI for a repository.
     */
    public static final String REPOSITORY_UI = "audit.channel.ui.repository";

    private Channels() {
        throw new UnsupportedOperationException(getClass().getName() + " is not intended to be instantiated.");
    }
}
