package com.atlassian.bitbucket.audit;

import com.atlassian.bitbucket.event.annotation.Audited;

import javax.annotation.Nonnull;

/**
 * Converts an {@link Audited} event into a standard audit format.
 * <p>
 * Implementations <i>must</i> have a nullary (no argument) constructor and are intended to be <i>lightweight,
 * stateless classes</i>. Converters are instantiated for <i>each event</i> and discarded after the event has
 * been converted.
 *
 * @param <T> the type of the original event
 */
public interface AuditEntryConverter<T> {

    /**
     * Converts an {@link Audited} event into a standard audit format.
     *
     * @param builder an audit entry builder which has the source IP address set by the caller
     * @param event   the original annotated event
     * @return the details of the original event in the standard audit format
     */
    @Nonnull
    AuditEntry convert(@Nonnull T event, AuditEntryBuilder builder);
}
