/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scope;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ProjectScope
implements Scope {
    private final Project project;

    public ProjectScope(@Nonnull Project project) {
        this.project = Objects.requireNonNull(project, "project");
    }

    @Override
    public <T> T accept(@Nonnull ScopeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProjectScope) {
            ProjectScope that = (ProjectScope)o;
            return Objects.equals(this.getProject(), that.getProject());
        }
        return false;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nonnull
    public Optional<Integer> getResourceId() {
        return Optional.of(this.project.getId());
    }

    @Override
    @Nonnull
    public ScopeType getType() {
        return ScopeType.PROJECT;
    }

    public int hashCode() {
        return Objects.hashCode(this.getProject());
    }
}

