/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestMergeRequest
extends AbstractPullRequestRequest {
    private final Map<String, Object> context;
    private final String message;
    private final String strategyId;
    private final int version;

    private PullRequestMergeRequest(Builder builder) {
        super(builder);
        this.context = builder.context.build();
        this.message = builder.message;
        this.strategyId = builder.strategyId;
        this.version = builder.version;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getStrategyId() {
        return this.strategyId;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final ImmutableMap.Builder<String, Object> context;
        private final int version;
        private String message;
        private String strategyId;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
            this.version = pullRequest.getVersion();
            this.context = ImmutableMap.builder();
        }

        public Builder(int repositoryId, long pullRequestId, int version) {
            super(repositoryId, pullRequestId);
            this.version = version;
            this.context = ImmutableMap.builder();
        }

        @Nonnull
        public PullRequestMergeRequest build() {
            return new PullRequestMergeRequest(this);
        }

        @Nonnull
        public Builder context(@Nonnull String key, @Nonnull Object value) {
            this.context.put((Object)key, value);
            return this.self();
        }

        @Nonnull
        public Builder context(@Nonnull Map<String, Object> value) {
            this.context.putAll(value);
            return this.self();
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder strategyId(@Nullable String value) {
            this.strategyId = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

