/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.server.Feature;
import javax.annotation.Nonnull;

public enum StandardFeature implements Feature
{
    ATTACHMENTS("attachments"),
    AUTH_CAPTCHA("auth.captcha"),
    FORKS("forks"),
    GETTING_STARTED("getting.started.page"),
    SMART_MIRRORS("smart.mirrors", true),
    PERSONAL_REPOS("personal.repos"),
    PUBLIC_ACCESS("public.access"),
    UPGRADE_ONBOARDING("upgrade.onboarding.page");

    private final boolean dataCenter;
    private final String key;

    private StandardFeature(String key) {
        this(key, false);
    }

    private StandardFeature(String key, boolean dataCenter) {
        this.dataCenter = dataCenter;
        this.key = key;
    }

    @Nonnull
    public static StandardFeature fromKey(String value) {
        for (StandardFeature feature : StandardFeature.values()) {
            if (!feature.getKey().equals(value)) continue;
            return feature;
        }
        throw new IllegalArgumentException("No Feature is associated with key [" + value + "]");
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isDataCenter() {
        return this.dataCenter;
    }
}

