/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DiffCommandParameters
extends AbstractDiffCommandParameters {
    private final String sinceId;
    private final String untilId;

    private DiffCommandParameters(int maxLines, int maxLineLength, int contextLines, DiffWhitespace whitespace, Set<String> paths, String untilId, String sinceId) {
        super(maxLineLength, maxLines, contextLines, whitespace, paths);
        this.sinceId = sinceId;
        this.untilId = untilId;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    @Nonnull
    public DiffContext toContext() {
        return this.toContext(new DiffContext.Builder(this.getSinceId(), this.getUntilId()));
    }

    public static class Builder
    extends AbstractDiffCommandParameters.AbstractBuilder<Builder> {
        private String sinceId;
        private String untilId;

        public DiffCommandParameters build() {
            if (StringUtils.isBlank((CharSequence)this.untilId)) {
                throw new IllegalStateException("An \"until\" ID is required to build a diff");
            }
            return new DiffCommandParameters(this.maxLines, this.maxLineLength, this.contextLines, this.whitespace, (Set)this.paths.build(), this.untilId, this.sinceId);
        }

        public Builder sinceId(String value) {
            this.sinceId = value;
            return this;
        }

        public Builder untilId(String value) {
            this.untilId = (String)Preconditions.checkNotNull((Object)value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

