/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.property;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;

public class SimplePropertySupport
implements PropertySupport {
    private transient PropertyMap properties;

    public SimplePropertySupport(@Nonnull AbstractPropertyBuilder<?> builder) {
        this.properties = builder.properties.build();
    }

    @Override
    @Nonnull
    public PropertyMap getProperties() {
        return this.properties;
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"properties");
        if (this.properties != null && !this.properties.isEmpty()) {
            throw new IllegalStateException("Properties have already been set; you cannot override once set.");
        }
        this.properties = properties;
    }

    public static abstract class AbstractPropertyBuilder<B extends AbstractPropertyBuilder<B>>
    extends BuilderSupport {
        protected final PropertyMap.Builder properties = new PropertyMap.Builder();

        protected AbstractPropertyBuilder() {
        }

        protected AbstractPropertyBuilder(@Nonnull PropertySupport entity) {
            this.properties(((PropertySupport)Preconditions.checkNotNull((Object)entity, (Object)"entity")).getProperties());
        }

        @Nonnull
        public B property(@Nonnull String key, @Nonnull Object value) {
            this.properties.property(key, value);
            return this.self();
        }

        @Nonnull
        public B properties(@Nonnull Map<String, Object> other) {
            this.properties.properties(other);
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

