/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DateFormatter {
    public static final String PROPERTY_KEY_PREFIX = "bitbucket.date.format";

    @Nonnull
    public String formatDate(@Nonnull Date var1, @Nonnull FormatType var2);

    @Nonnull
    public String formatInstant(@Nonnull Instant var1, @Nonnull FormatType var2);

    @Nullable
    public String getFormatString(@Nullable String var1);

    public static enum FormatType {
        SHORT("bitbucket.date.format.short"),
        LONG("bitbucket.date.format.long"),
        FULL("bitbucket.date.format.full"),
        DATETIME("bitbucket.date.format.datetime"),
        TIMESTAMP("bitbucket.date.format.timestamp"),
        TIMEONLY("bitbucket.date.format.timeonly"),
        SHORTAGE(SHORT),
        LONGAGE(LONG);

        final String key;
        final boolean age;

        private FormatType(FormatType delegate) {
            this.key = delegate.key;
            this.age = true;
        }

        private FormatType(String key) {
            this.key = key;
            this.age = false;
        }

        public boolean isAge() {
            return this.age;
        }

        public String getKey() {
            return this.key;
        }

        @Nonnull
        public static FormatType fromString(@Nonnull String s) {
            return FormatType.valueOf(Objects.requireNonNull(s).toUpperCase(Locale.ROOT));
        }
    }
}

