/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleRefChange
implements RefChange {
    private final MinimalRef ref;
    private final String fromHash;
    private final String toHash;
    private final RefChangeType type;

    protected SimpleRefChange(@Nonnull MinimalRef ref, @Nonnull String fromHash, @Nonnull String toHash, @Nonnull RefChangeType type) {
        this.fromHash = fromHash;
        this.ref = ref;
        this.toHash = toHash;
        this.type = type;
    }

    @Override
    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Override
    @Nonnull
    public MinimalRef getRef() {
        return this.ref;
    }

    @Override
    @Nonnull
    public String getRefId() {
        return this.ref.getId();
    }

    @Override
    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Override
    @Nonnull
    public RefChangeType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleRefChange) {
            SimpleRefChange that = (SimpleRefChange)o;
            return this.fromHash.equals(that.fromHash) && Objects.equals(this.ref.getId(), that.ref.getId()) && Objects.equals(this.ref.getType(), that.ref.getType()) && this.toHash.equals(that.toHash) && this.type.equals((Object)that.type);
        }
        return false;
    }

    public int hashCode() {
        int result = this.ref.getId().hashCode();
        result = 31 * result + this.fromHash.hashCode();
        result = 31 * result + this.toHash.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.getRef().getId() + ": " + this.getFromHash() + " -> " + this.getToHash() + " (" + (Object)((Object)this.getType()) + ")";
    }

    public static class Builder {
        private String fromHash;
        private MinimalRef ref;
        private String toHash;
        private RefChangeType type;

        public Builder() {
        }

        public Builder(@Nonnull RefChange change) {
            this.fromHash = ((RefChange)Preconditions.checkNotNull((Object)change, (Object)"change")).getFromHash();
            this.ref = change.getRef();
            this.toHash = change.getToHash();
            this.type = change.getType();
        }

        @Nonnull
        public SimpleRefChange build() {
            Preconditions.checkNotNull((Object)this.fromHash, (Object)"fromHash");
            Preconditions.checkNotNull((Object)this.ref, (Object)"ref");
            Preconditions.checkNotNull((Object)this.toHash, (Object)"toHash");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"type");
            return new SimpleRefChange(this.ref, this.fromHash, this.toHash, this.type);
        }

        @Nonnull
        public Builder from(@Nonnull Ref value) {
            this.fromHash = ((Ref)Preconditions.checkNotNull((Object)value, (Object)"ref")).getLatestCommit();
            return this.ref(value);
        }

        @Nonnull
        public Builder fromHash(@Nonnull String value) {
            this.fromHash = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder ref(@Nonnull MinimalRef value) {
            this.ref = (MinimalRef)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder to(@Nonnull Ref value) {
            this.toHash = ((Ref)Preconditions.checkNotNull((Object)value, (Object)"ref")).getLatestCommit();
            return this.ref(value);
        }

        @Nonnull
        public Builder toHash(@Nonnull String value) {
            this.toHash = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull RefChangeType value) {
            this.type = (RefChangeType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value"));
            return this;
        }
    }
}

