/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RefMetadataRequest {
    private final Map<String, Object> context;
    private final Ref baseRef;
    private final Set<Ref> refs;
    private final Repository repository;

    private RefMetadataRequest(Builder builder) {
        this.context = builder.context.build();
        this.baseRef = builder.baseRef;
        this.refs = builder.refs.build();
        this.repository = builder.repository;
        Preconditions.checkState((!this.refs.isEmpty() ? 1 : 0) != 0, (Object)"At least one ref must be specified");
        Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"A repository is required");
    }

    @Nullable
    public Ref getBaseRef() {
        return this.baseRef;
    }

    @Nonnull
    public Set<Ref> getRefs() {
        return this.refs;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableMap.Builder<String, Object> context = ImmutableMap.builder();
        private final ImmutableSet.Builder<Ref> refs = ImmutableSet.builder();
        private Ref baseRef;
        private Repository repository;

        public Builder() {
        }

        public Builder(RefMetadataRequest request) {
            this();
            this.baseRef(request.getBaseRef()).refs(request.getRefs()).repository(request.getRepository());
        }

        public RefMetadataRequest build() {
            return new RefMetadataRequest(this);
        }

        public Builder baseRef(Ref baseRef) {
            this.baseRef = baseRef;
            return this;
        }

        public Builder refs(Iterable<? extends Ref> values) {
            Builder.addIf(Objects::nonNull, this.refs, values);
            return this;
        }

        public Builder refs(Ref value, Ref ... values) {
            Builder.addIf(Objects::nonNull, this.refs, value, values);
            return this;
        }

        public Builder repository(Repository value) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)value, (Object)"repository");
            return this;
        }

        @Nonnull
        public Builder context(@Nonnull Map<String, Object> value) {
            this.context.putAll((Map)Preconditions.checkNotNull(value, (Object)"context"));
            return this;
        }
    }
}

