/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public enum PullRequestRole {
    AUTHOR(0, true),
    REVIEWER(1, true),
    PARTICIPANT(2, false);

    private final int id;
    private final boolean explicit;

    private PullRequestRole(int id, boolean explicit) {
        this.id = id;
        this.explicit = explicit;
    }

    @Nonnull
    public static PullRequestRole fromId(int id) {
        for (PullRequestRole value : PullRequestRole.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No PullRequestRole is associated with ID [" + id + "]");
    }

    @Nonnull
    public Predicate<PullRequestParticipant> getFilter() {
        return participant -> participant.getRole() == this;
    }

    public int getId() {
        return this.id;
    }

    public boolean isExplicit() {
        return this.explicit;
    }
}

