/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.AbstractCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class CommitsBetweenRequest
extends AbstractCommitsRequest {
    private final Set<String> excludes;
    private final Set<String> includes;
    private final Repository secondaryRepository;

    private CommitsBetweenRequest(Builder builder) {
        super(builder);
        this.excludes = builder.excludes.build();
        this.includes = builder.includes.build();
        this.secondaryRepository = builder.secondaryRepository;
        Repository repository = super.getRepository();
        if (this.secondaryRepository != null && ObjectUtils.notEqual((Object)repository.getHierarchyId(), (Object)this.secondaryRepository.getHierarchyId())) {
            throw new IllegalStateException(this.secondaryRepository.getProject().getKey() + "/" + this.secondaryRepository.getSlug() + " is not from the same hierarchy as " + repository.getProject().getKey() + "/" + repository.getSlug() + "; commits may only be streamed between repositories from the same hierarchy.");
        }
        if (this.includes.isEmpty()) {
            throw new IllegalStateException("At least one commit must be provided to include");
        }
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    public int getMaxMessageLength() {
        return super.getMaxMessageLength();
    }

    @Override
    @Nonnull
    public Set<String> getPaths() {
        return super.getPaths();
    }

    @Override
    @Nonnull
    public Set<String> getPropertyKeys() {
        return super.getPropertyKeys();
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return super.getRepository();
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    @Override
    public boolean isFollowingRenames() {
        return super.isFollowingRenames();
    }

    @Override
    @Deprecated
    @Nullable
    public Boolean isIgnoringMissing() {
        return super.isIgnoringMissing();
    }

    public static class Builder
    extends AbstractCommitsRequest.AbstractCommitsRequestBuilder<Builder> {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private Repository secondaryRepository;

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull CommitsBetweenRequest request) {
            super(request);
            this.exclude(request.getExcludes()).include(request.getIncludes()).maxMessageLength(request.getMaxMessageLength()).secondaryRepository(request.getSecondaryRepository());
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getFromRef(), pullRequest.getToRef());
        }

        private Builder(@Nonnull PullRequestRef fromRef, @Nonnull PullRequestRef toRef) {
            super(Objects.requireNonNull(toRef, "pullRequest.toRef").getRepository());
            Objects.requireNonNull(fromRef, "pullRequest.fromRef");
            this.exclude(Objects.requireNonNull(toRef.getLatestCommit(), "pullRequest.toRef.latestCommit"), new String[0]).include(Objects.requireNonNull(fromRef.getLatestCommit(), "pullRequest.fromRef.latestCommit"), new String[0]);
            if (toRef.getRepository().getId() != fromRef.getRepository().getId()) {
                this.secondaryRepository(fromRef.getRepository());
            }
        }

        @Nonnull
        public CommitsBetweenRequest build() {
            return new CommitsBetweenRequest(this);
        }

        @Nonnull
        public Builder exclude(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.excludes, value, values);
            return this.self();
        }

        @Nonnull
        public Builder exclude(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.excludes, values);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder followRenames(boolean value) {
            return (Builder)super.followRenames(value);
        }

        @Override
        @Nonnull
        public Builder ignoreMissing(@Nullable Boolean value) {
            return (Builder)super.ignoreMissing(value);
        }

        @Nonnull
        public Builder include(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.includes, value, values);
            return this.self();
        }

        @Nonnull
        public Builder include(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.includes, values);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder maxMessageLength(int value) {
            return (Builder)super.maxMessageLength(value);
        }

        @Override
        @Nonnull
        public Builder path(@Nullable String value) {
            return (Builder)super.path(value);
        }

        @Override
        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            return (Builder)super.paths(values);
        }

        @Override
        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            return (Builder)super.paths(value, values);
        }

        @Override
        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            return (Builder)super.propertyKey(value);
        }

        @Override
        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            return (Builder)super.propertyKeys(values);
        }

        @Override
        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            return (Builder)super.propertyKeys(value, values);
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

