/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.ResolveRefsRequest;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResolveRefsCommandParameters
extends AbstractCommandParameters {
    private final Set<String> branchIds;
    private final Set<String> refIds;
    private final Set<String> tagIds;

    private ResolveRefsCommandParameters(Builder builder) {
        this.branchIds = builder.branchIds.build();
        this.refIds = builder.refIds.build();
        this.tagIds = builder.tagIds.build();
    }

    @Nonnull
    public Set<String> getBranchIds() {
        return this.branchIds;
    }

    @Nonnull
    public Set<String> getRefIds() {
        return this.refIds;
    }

    @Nonnull
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> branchIds = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> refIds = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> tagIds = ImmutableSet.builder();

        public Builder() {
        }

        public Builder(@Nonnull ResolveRefsRequest request) {
            this();
            this.branchIds(Objects.requireNonNull(request, "request").getBranchIds()).refIds(request.getRefIds()).tagIds(request.getTagIds());
        }

        @Nonnull
        public Builder branchId(@Nullable String value) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.branchIds, value);
            return this;
        }

        @Nonnull
        public Builder branchIds(@Nullable String value, String ... moreValues) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.branchIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder branchIds(@Nullable Iterable<String> values) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.branchIds, values);
            return this;
        }

        @Nonnull
        public ResolveRefsCommandParameters build() {
            return new ResolveRefsCommandParameters(this);
        }

        @Nonnull
        public Builder refId(@Nullable String value) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.refIds, value);
            return this;
        }

        @Nonnull
        public Builder refIds(@Nullable String value, String ... moreValues) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.refIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder refIds(@Nullable Iterable<String> values) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.refIds, values);
            return this;
        }

        @Nonnull
        public Builder tagId(@Nullable String value) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.tagIds, value);
            return this;
        }

        @Nonnull
        public Builder tagIds(@Nullable String value, String ... moreValues) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.tagIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder tagIds(@Nullable Iterable<String> values) {
            ResolveRefsCommandParameters.addIf(NOT_BLANK, this.tagIds, values);
            return this;
        }
    }
}

