/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.validation;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;

public abstract class BaseUrlValidator<T extends Annotation>
implements ConstraintValidator<T, String> {
    protected final boolean allowPath;
    protected final Set<String> schemes;

    protected BaseUrlValidator(boolean allowPath, String ... schemes) {
        this.allowPath = allowPath;
        this.schemes = ImmutableSet.copyOf((Object[])schemes);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        URI uri;
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        try {
            uri = new URI(this.clean(value));
        }
        catch (URISyntaxException e) {
            return false;
        }
        return this.isValid(uri);
    }

    protected boolean isValid(URI uri) {
        if (!this.schemes.contains(uri.getScheme())) {
            return false;
        }
        if (StringUtils.isEmpty((String)uri.getHost())) {
            return false;
        }
        if (uri.getAuthority().endsWith(":")) {
            return false;
        }
        for (String component : new String[]{uri.getUserInfo(), uri.getQuery(), uri.getFragment()}) {
            if (!StringUtils.isNotEmpty((String)component)) continue;
            return false;
        }
        return this.allowPath || !StringUtils.isNotEmpty((String)uri.getPath());
    }

    private String clean(String value) {
        int i;
        for (i = value.length() - 1; i > 0 && value.charAt(i) == '/'; --i) {
        }
        return value.substring(0, i + 1);
    }
}

