/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.task;

import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class TaskUpdateRequest {
    private final TaskState state;
    private final Task task;
    private final String text;

    private TaskUpdateRequest(Builder builder) {
        this.state = builder.state;
        this.task = (Task)Preconditions.checkNotNull((Object)builder.task, (Object)"task");
        this.text = builder.text;
    }

    public TaskState getState() {
        return this.state;
    }

    public Task getTask() {
        return this.task;
    }

    public String getText() {
        return this.text;
    }

    public static class Builder {
        private final Task task;
        private TaskState state;
        private String text;

        public Builder(Task task) {
            this.task = (Task)Preconditions.checkNotNull((Object)task, (Object)"task");
        }

        public TaskUpdateRequest build() {
            return new TaskUpdateRequest(this);
        }

        public Builder state(@Nonnull TaskState value) {
            this.state = (TaskState)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
            return this;
        }

        public Builder text(@Nonnull String value) {
            this.text = (String)Preconditions.checkNotNull((Object)value, (Object)"text");
            return this;
        }
    }
}

