/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.ContentTreeContext;
import com.atlassian.bitbucket.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DirectoryCommandParameters
extends AbstractCommitCommandParameters {
    private final boolean recursive;

    private DirectoryCommandParameters(Builder builder) {
        super(builder);
        if (StringUtils.isBlank((String)this.getCommitId())) {
            throw new IllegalStateException("A commit ID must be provided when retrieving directory contents");
        }
        this.recursive = builder.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Nonnull
    public ContentTreeContext toContext() {
        return new ContentTreeContext.Builder(this.getCommitId()).recursive(this.isRecursive()).build();
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private boolean recursive;

        @Nonnull
        public DirectoryCommandParameters build() {
            return new DirectoryCommandParameters(this);
        }

        @Nonnull
        public Builder recurse(boolean value) {
            this.recursive = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

