/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RepositoryForkRequest
extends AbstractRepositoryRequest {
    private final Repository parent;
    private final Project project;

    private RepositoryForkRequest(String name, boolean forkable, Repository parent, Project project, boolean publiclyAccessible) {
        super(name, forkable, publiclyAccessible);
        this.parent = parent;
        this.project = project;
    }

    @Nonnull
    public Repository getParent() {
        return this.parent;
    }

    @Nullable
    public Project getProject() {
        return this.project;
    }

    public static class Builder
    extends AbstractRepositoryRequest.AbstractBuilder<Builder> {
        private Repository parent;
        private Project project;

        public Builder() {
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
            this.parent = repository;
            this.publiclyAccessible = false;
        }

        public Builder(@Nonnull RepositoryForkRequest request) {
            super(request);
            this.parent = request.getParent();
            this.project = request.getProject();
        }

        @Nonnull
        public RepositoryForkRequest build() {
            Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"parent");
            return new RepositoryForkRequest(StringUtils.defaultIfBlank((String)this.name, (String)this.parent.getName()), this.forkable, this.parent, this.project, this.publiclyAccessible);
        }

        @Override
        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this.self();
        }

        @Nonnull
        public Builder parent(@Nonnull Repository value) {
            this.parent = (Repository)Preconditions.checkNotNull((Object)value, (Object)"parent");
            return this.self();
        }

        @Nonnull
        public Builder project(@Nullable Project value) {
            this.project = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

