/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class RepositoryCreateRequest
extends AbstractRepositoryRequest {
    private final Project project;
    private final String scmId;

    private RepositoryCreateRequest(String name, boolean forkable, Project project, String scmId, boolean publiclyAccessible) {
        super(name, forkable, publiclyAccessible);
        this.project = project;
        this.scmId = scmId;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    public static class Builder
    extends AbstractRepositoryRequest.AbstractBuilder<Builder> {
        private Project project;
        private String scmId;

        public Builder() {
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
            this.project = repository.getProject();
            this.scmId = repository.getScmId();
        }

        public Builder(@Nonnull RepositoryCreateRequest request) {
            super(request);
            this.project = request.getProject();
            this.scmId = request.getScmId();
        }

        @Nonnull
        public RepositoryCreateRequest build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (Object)"The name for the new repository is required");
            Preconditions.checkState((this.project != null ? 1 : 0) != 0, (Object)"The project in which to create the repository is required");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.scmId), (Object)"The SCM type for the new repository is required");
            return new RepositoryCreateRequest(this.name, this.forkable, this.project, this.scmId, this.publiclyAccessible);
        }

        @Nonnull
        public Builder project(@Nonnull Project value) {
            this.project = (Project)Preconditions.checkNotNull((Object)value, (Object)"project");
            return this.self();
        }

        @Nonnull
        public Builder scmId(@Nonnull String value) {
            this.scmId = Builder.checkNotBlank(value, "scmId");
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

