/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class CreateTagRequest {
    private final String message;
    private final String name;
    private final Repository repository;
    private final String startPoint;

    private CreateTagRequest(Builder builder) {
        this.message = builder.message;
        this.name = builder.name;
        this.repository = builder.repository;
        this.startPoint = builder.startPoint;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getStartPoint() {
        return this.startPoint;
    }

    public static class Builder
    extends BuilderSupport {
        private final String name;
        private final Repository repository;
        private final String startPoint;
        private String message;

        public Builder(@Nonnull Repository repository, @Nonnull String name, @Nonnull String startPoint) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.name = Builder.checkNotBlank(name, "name");
            this.startPoint = Builder.checkNotBlank(startPoint, "startPoint");
        }

        @Nonnull
        public CreateTagRequest build() {
            return new CreateTagRequest(this);
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = StringUtils.trimToNull((String)value);
            return this;
        }
    }
}

