/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.project.AbstractProjectRequest;
import com.atlassian.bitbucket.project.Project;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ProjectUpdateRequest
extends AbstractProjectRequest {
    private final int id;

    private ProjectUpdateRequest(int id, String key, String name, String description, boolean publiclyAccessible) {
        super(key, name, description, publiclyAccessible);
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static class Builder
    extends AbstractProjectRequest.AbstractBuilder<Builder> {
        private final int id;

        public Builder(@Nonnull Project project) {
            super(project);
            this.id = project.getId();
        }

        public Builder(int id) {
            this.id = id;
        }

        @Nonnull
        public ProjectUpdateRequest build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.key), (Object)"The key with which to update the project is required");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (Object)"The name with which to update the project is required");
            return new ProjectUpdateRequest(this.id, this.key, this.name, this.description, this.publiclyAccessible);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

