/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.project.AbstractProjectRequest;
import com.atlassian.bitbucket.project.Project;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ProjectCreateRequest
extends AbstractProjectRequest {
    private final AvatarSupplier avatar;
    private final String avatarUri;

    private ProjectCreateRequest(String key, String name, String description, AvatarSupplier avatar, String avatarUri, boolean publiclyAccessible) {
        super(key, name, description, publiclyAccessible);
        this.avatar = avatar;
        this.avatarUri = avatarUri;
    }

    @Nullable
    public AvatarSupplier getAvatar() {
        return this.avatar;
    }

    @Nullable
    public String getAvatarUri() {
        return this.avatarUri;
    }

    public static class Builder
    extends AbstractProjectRequest.AbstractBuilder<Builder> {
        private String avatarUri;
        private AvatarSupplier avatar;

        public Builder() {
        }

        public Builder(Project project) {
            super(project);
        }

        @Nonnull
        public Builder avatar(@Nullable AvatarSupplier value) {
            this.avatar = value;
            return this.self();
        }

        @Nonnull
        public Builder avatarUri(@Nullable String value) {
            this.avatarUri = value;
            return this.self();
        }

        @Nonnull
        public ProjectCreateRequest build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.key), (Object)"The key with which to create the project is required");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (Object)"The name with which to create the project is required");
            Preconditions.checkState((this.avatarUri == null || this.avatar == null ? 1 : 0) != 0, (Object)"Both an avatar and avatarUri cannot be provided");
            return new ProjectCreateRequest(this.key, this.name, this.description, this.avatar, this.avatarUri, this.publiclyAccessible);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

