/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAddCommentRequest {
    private final String fromHash;
    private final String path;
    private final String srcPath;
    private final String text;
    private final String toHash;

    protected AbstractAddCommentRequest(AbstractBuilder<?, ?> builder) {
        this.fromHash = StringUtils.trimToNull((String)((AbstractBuilder)builder).fromHash);
        this.path = (String)Preconditions.checkNotNull((Object)((AbstractBuilder)builder).path, (Object)"path");
        this.srcPath = StringUtils.trimToNull((String)((AbstractBuilder)builder).srcPath);
        this.text = (String)Preconditions.checkNotNull((Object)((AbstractBuilder)builder).text, (Object)"text");
        this.toHash = StringUtils.trimToNull((String)((AbstractBuilder)builder).toHash);
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Nullable
    public String getToHash() {
        return this.toHash;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractAddCommentRequest>
    extends BuilderSupport {
        private String fromHash;
        private String path;
        private String srcPath;
        private String text;
        private String toHash;

        @Nonnull
        public abstract R build();

        @Nonnull
        public B fromHash(@Nullable String value) {
            this.fromHash = value;
            return this.self();
        }

        @Nonnull
        public B path(@Nonnull String value) {
            this.path = AbstractBuilder.checkNotBlank(value, "path");
            return this.self();
        }

        @Nonnull
        public B srcPath(@Nullable String value) {
            this.srcPath = value;
            return this.self();
        }

        @Nonnull
        public B text(@Nonnull String value) {
            this.text = AbstractBuilder.checkNotBlank(value, "text");
            return this.self();
        }

        @Nonnull
        public B toHash(@Nullable String value) {
            this.toHash = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

