/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search.internal;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.search.embedded.EmbeddedSearchServer;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class EmbeddedOpenSearch
implements LifecycleAware,
EmbeddedSearchServer {
    private static final Path JAVA_EXECUTABLE_PATH = Paths.get("bin", "java");
    private static final String OPENSEARCH_BUNDLE_RESOURCE = "bundle/opensearch-min.tar.gz";
    private static final Path OPENSEARCH_CONFIG_PATH = Paths.get("config", new String[0]);
    private static final Path OPENSEARCH_LIB_PATH = Paths.get("lib", new String[0]);
    private static final String OPENSEARCH_MAIN_CLASS = "org.opensearch.bootstrap.OpenSearch";
    private static final int OPENSEARCH_SHUTDOWN_WAIT_TIMEOUT_SECONDS = 15;
    private static final long OPENSEARCH_STARTUP_WAIT_INTERVAL_MILLIS = 1000L;
    private static final int OPENSEARCH_STARTUP_WAIT_TIMEOUT_SECONDS = 45;
    private static final String PLUGIN_SETTINGS_KEY_PREFIX = "plugin.embedded-elasticsearch.";
    private static final String SETTING_HTTP_PORT = "http.port";
    private static final String SETTING_PATH_DATA = "path.data";
    private static final String SETTING_PATH_CONFIG = "path.conf";
    private static final String SETTING_PATH_HOME = "path.home";
    private static final String SETTING_PATH_LOGS = "path.logs";
    private static final String SETTING_TCP_PORT = "transport.tcp.port";
    private static final String STARTING_LOCK_NAME = EmbeddedOpenSearch.class.getName() + ":startLock";
    private static final Logger log = LoggerFactory.getLogger(EmbeddedOpenSearch.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ClusterService clusterService;
    private final LockService lockService;
    private final StorageService storageService;
    private volatile ExecutorService executorService;
    private volatile Process proc;
    private volatile boolean stopping;

    public EmbeddedOpenSearch(ApplicationPropertiesService applicationPropertiesService, ClusterService clusterService, LockService lockService, StorageService storageService) {
        this.applicationPropertiesService = Objects.requireNonNull(applicationPropertiesService);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.lockService = Objects.requireNonNull(lockService);
        this.storageService = Objects.requireNonNull(storageService);
    }

    public void onStart() {
        Lock startLock;
        if (this.clusterService.getInformation().isNetworkingEnabled() && !(startLock = this.lockService.getLock(STARTING_LOCK_NAME)).tryLock()) {
            log.info("Another node is currently acting as the primary OpenSearch node, cancelling start.");
            return;
        }
        String version = EmbeddedOpenSearch.getBundledOpenSearchVersion();
        Map<String, String> settings = this.getOpenSearchSettings();
        Path destination = Paths.get(settings.get(SETTING_PATH_HOME), new String[0]);
        EmbeddedOpenSearch.unpackBundleTo(destination);
        String classPath = destination.resolve(OPENSEARCH_LIB_PATH) + File.separator + "*";
        this.startExecutorService();
        try {
            List<String> jvmOptions = this.readDefaultJvmOptions(classPath, destination);
            List<String> args = EmbeddedOpenSearch.newJavaCommand(classPath);
            args.addAll(jvmOptions);
            args.add("-Dopensearch.path.conf=" + settings.remove(SETTING_PATH_CONFIG));
            args.add(OPENSEARCH_MAIN_CLASS);
            args.addAll(settings.entrySet().stream().flatMap(entry -> Stream.of("-E", (String)entry.getKey() + "=" + (String)entry.getValue())).collect(Collectors.toList()));
            log.info("Starting OpenSearch {} on ports: {}/http, {}/tcp...", new Object[]{version, settings.get(SETTING_HTTP_PORT), settings.get(SETTING_TCP_PORT)});
            log.debug("Starting OpenSearch with args: {}", args);
            this.proc = EmbeddedOpenSearch.startProcess(destination, args, Collections.emptyMap(), true);
            this.startLogger(this.proc.getInputStream());
            this.startProcessReaper(this.proc);
            EmbeddedOpenSearch.waitUntilStarted(settings);
            log.info("Started OpenSearch successfully.");
        }
        catch (IOException e) {
            this.stop();
            throw new RuntimeException("Could not start OpenSearch", e);
        }
        catch (IllegalStateException e) {
            this.stop();
            throw e;
        }
        catch (InterruptedException e) {
            this.stop();
            log.info("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static List<String> newJavaCommand(String classPath) {
        return new ArrayList<String>((Collection<String>)ImmutableList.of((Object)Paths.get(SystemUtils.JAVA_HOME, new String[0]).resolve(JAVA_EXECUTABLE_PATH).toString(), (Object)"-cp", (Object)classPath));
    }

    public void onStop() {
        this.stop();
    }

    private static String getBundledOpenSearchVersion() {
        try {
            Properties props = new Properties();
            props.load(new ClassPathResource("opensearch.properties", EmbeddedOpenSearch.class.getClassLoader()).getInputStream());
            return String.valueOf(props.get("opensearch.version"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load OpenSearch version", e);
        }
    }

    private List<String> readDefaultJvmOptions(String classPath, Path destination) throws IOException, InterruptedException {
        List<String> tempDirectoryCommand = EmbeddedOpenSearch.newJavaCommand(classPath);
        tempDirectoryCommand.add("org.opensearch.tools.launchers.TempDirectory");
        String openSearchTmpDir = this.runCommand(destination, tempDirectoryCommand, Collections.emptyMap())[0].trim();
        List<String> jvmOptionsParserCommand = EmbeddedOpenSearch.newJavaCommand(classPath);
        jvmOptionsParserCommand.add("org.opensearch.tools.launchers.JvmOptionsParser");
        jvmOptionsParserCommand.add(destination.resolve(OPENSEARCH_CONFIG_PATH).toString());
        String openSearchJavaOpts = this.runCommand(destination, jvmOptionsParserCommand, (Map<String, String>)ImmutableMap.of((Object)"OPENSEARCH_TMPDIR", (Object)openSearchTmpDir))[0].trim();
        return Arrays.asList(openSearchJavaOpts.split(" "));
    }

    /*
     * Exception decompiling
     */
    private String[] runCommand(Path destination, List<String> command, Map<String, String> env) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Future<?> startPump(ByteArrayOutputStream buffer, InputStream stream) {
        return this.executorService.submit(() -> {
            try (InputStream is = stream;){
                int read;
                byte[] buf = new byte[32768];
                while ((read = is.read(buf)) != -1) {
                    buffer.write(buf, 0, read);
                }
            }
            catch (IOException e) {
                log.error("Exception caught:", (Throwable)e);
            }
        });
    }

    private static Process startProcess(Path directory, List<String> args, Map<String, String> env, boolean redirectErrorStream) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(directory.toFile());
        builder.redirectErrorStream(redirectErrorStream);
        ConcurrentHashMap<String, String> processEnv = new ConcurrentHashMap<String, String>();
        processEnv.putAll(builder.environment());
        processEnv.putAll(env);
        processEnv.computeIfPresent("JAVA_TOOL_OPTIONS", (key, value) -> {
            log.warn("[startProcess]: Moving {}={} to OPENSEARCH_JAVA_OPTS", key, value);
            processEnv.compute("OPENSEARCH_JAVA_OPTS", (key2, value2) -> {
                if (value2 != null) {
                    return value2 + " " + value;
                }
                return value;
            });
            return null;
        });
        builder.environment().putAll(processEnv);
        return builder.start();
    }

    private static void unpackBundleTo(Path destination) {
        try (InputStream inputStream = new ClassPathResource(OPENSEARCH_BUNDLE_RESOURCE, EmbeddedOpenSearch.class.getClassLoader()).getInputStream();
             GZIPInputStream gzip = new GZIPInputStream(inputStream);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzip);){
            ArchiveEntry entry;
            HashSet<Path> unpackedEntries = new HashSet<Path>();
            while ((entry = tar.getNextEntry()) != null) {
                Path entryPath = Paths.get(entry.getName().replace('/', File.separatorChar), new String[0]);
                if (entryPath.getNameCount() <= 1) continue;
                entryPath = entryPath.subpath(1, entryPath.getNameCount());
                Path destinationFile = destination.resolve(entryPath);
                unpackedEntries.add(entryPath);
                if (entry.isDirectory()) {
                    Files.createDirectories(destinationFile, new FileAttribute[0]);
                    continue;
                }
                FileTime lastModifiedTime = null;
                try {
                    lastModifiedTime = Files.getLastModifiedTime(destinationFile, new LinkOption[0]);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
                Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                if (Objects.compare(lastModifiedTime, FileTime.from(entry.getLastModifiedDate().toInstant()), Comparator.nullsFirst(Comparator.naturalOrder())) >= 0) continue;
                Files.copy((InputStream)tar, destinationFile, new CopyOption[0]);
                Files.setLastModifiedTime(destinationFile, FileTime.from(entry.getLastModifiedDate().toInstant()));
            }
            Files.walk(destination, new FileVisitOption[0]).map(destination::relativize).filter(path -> !path.startsWith("data") && !path.startsWith("logs")).filter(path -> !Paths.get("", new String[0]).equals(path)).filter(path -> !unpackedEntries.contains(path)).sorted(Comparator.reverseOrder()).peek(path -> log.debug("Deleting leftover file from previous installation: {}", path)).map(destination::resolve).map(Path::toFile).forEach(file -> {
                boolean delete = file.delete();
                if (!delete) {
                    log.error("Could not delete leftover file {}", file);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not unpack bundle", e);
        }
    }

    private static void waitUntilStarted(Map<String, String> settings) {
        int port = Integer.parseInt(settings.get(SETTING_HTTP_PORT));
        try {
            String hostName = "localhost";
            Instant start = Instant.now();
            IOException lastError = null;
            while (start.plus(Duration.ofSeconds(45L)).isAfter(Instant.now())) {
                try {
                    Socket ignored = new Socket(hostName, port);
                    Throwable throwable = null;
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    lastError = e;
                    log.debug("Waiting for OpenSearch to start...");
                    Thread.sleep(1000L);
                }
            }
            throw new IllegalStateException("Timed out waiting for OpenSearch to start", lastError);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private Path createInstallDirectory() {
        Path directory = this.storageService.getHomeDir().resolve(Paths.get("search", new String[0]));
        try {
            return Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Could not create a directory at {}", (Object)directory, (Object)e);
            throw new RuntimeException("Failed to create directory", e);
        }
    }

    private Map<String, String> getOpenSearchSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        com.google.common.base.Supplier installDirectory = Suppliers.memoize(this::createInstallDirectory);
        this.updateSettingWithOverride(settings, SETTING_PATH_HOME, ((Supplier)installDirectory)::get);
        Path home = Paths.get((String)settings.get(SETTING_PATH_HOME), new String[0]);
        this.updateSettingWithOverride(settings, SETTING_PATH_DATA, () -> home.resolve("data"));
        this.updateSettingWithOverride(settings, SETTING_PATH_CONFIG, () -> home.resolve("config"));
        this.updateSettingWithOverride(settings, SETTING_PATH_LOGS, () -> home.resolve("logs"));
        this.updateSettingWithOverride(settings, SETTING_HTTP_PORT, 7992);
        this.updateSettingWithOverride(settings, SETTING_TCP_PORT, 7993);
        this.updateSettingWithOverride(settings, "action.auto_create_index", false);
        this.updateSettingWithOverride(settings, "node.name", "node");
        this.updateSettingWithOverride(settings, "discovery.type", "single-node");
        this.updateSettingWithOverride(settings, "cluster.routing.allocation.disk.threshold_enabled", false);
        return settings;
    }

    private void startExecutorService() {
        this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"embedded-opensearch", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    private void startLogger(InputStream inputStream) {
        this.executorService.submit(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info("[OpenSearch] {}", (Object)line);
                }
            }
            catch (IOException e) {
                log.error("Failed reading log output", (Throwable)e);
            }
        });
    }

    private void startProcessReaper(Process proc) {
        this.executorService.submit(() -> {
            try {
                int code = proc.waitFor();
                if (!this.stopping) {
                    if (code != 0) {
                        log.warn("OpenSearch exited irregularly - see logs for details.");
                    }
                    this.stopExecutorService();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private void stop() {
        this.stopping = true;
        try {
            this.stopProcess();
            this.stopExecutorService();
        }
        finally {
            this.stopping = false;
        }
    }

    private void stopExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void stopProcess() {
        if (this.proc != null) {
            log.info("Stopping OpenSearch...");
            try {
                this.proc.destroy();
                if (!this.proc.waitFor(15L, TimeUnit.SECONDS)) {
                    this.proc.destroyForcibly();
                    if (!this.proc.waitFor(15L, TimeUnit.SECONDS)) {
                        log.error("Timed out waiting for OpenSearch to stop");
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.proc = null;
            }
            log.info("Stopped OpenSearch successfully.");
        }
    }

    private void updateSettingWithOverride(Map<String, String> settings, String property, Supplier<Object> defaultValueSupplier) {
        String pluginProperty = PLUGIN_SETTINGS_KEY_PREFIX + property;
        String value = this.applicationPropertiesService.getPluginProperty(pluginProperty);
        if (value == null) {
            String defaultValue = String.valueOf(defaultValueSupplier.get());
            settings.put(property, defaultValue);
            return;
        }
        settings.put(property, value);
    }

    private void updateSettingWithOverride(Map<String, String> settings, String property, Object defaultValue) {
        this.updateSettingWithOverride(settings, property, () -> defaultValue);
    }
}

