/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search.internal;

import com.atlassian.bitbucket.search.elasticsearch.embedded.EmbeddedElasticseachServer;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class EmbeddedElasticsearch
implements LifecycleAware,
EmbeddedElasticseachServer {
    private static final String ES_BUNDLE_RESOURCE = "bundle/elasticsearch.zip";
    private static final Path ES_JVM_OPTIONS_PATH = Paths.get("config", "jvm.options");
    private static final Path ES_LIB_PATH = Paths.get("lib", new String[0]);
    private static final String ES_MAIN_CLASS = "org.elasticsearch.bootstrap.Elasticsearch";
    private static final int ES_SHUTDOWN_WAIT_TIMEOUT_SECONDS = 15;
    private static final long ES_STARTUP_WAIT_INTERVAL_MILLIS = 1000L;
    private static final int ES_STARTUP_WAIT_TIMEOUT_SECONDS = 45;
    private static final Path JAVA_EXECUTABLE_PATH = Paths.get("bin", "java");
    private static final Pattern LINE_COMMENT_PATTERN = Pattern.compile("#.*$");
    private static final String PLUGIN_SETTINGS_KEY_PREFIX = "plugin.embedded-elasticsearch.";
    private static final String SETTING_HTTP_PORT = "http.port";
    private static final String SETTING_PATH_DATA = "path.data";
    private static final String SETTING_PATH_HOME = "path.home";
    private static final String SETTING_PATH_LOGS = "path.logs";
    private static final String SETTING_TCP_PORT = "transport.tcp.port";
    private static final Logger log = LoggerFactory.getLogger(EmbeddedElasticsearch.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final StorageService storageService;
    private volatile ExecutorService executorService;
    private volatile Process proc;
    private volatile boolean stopping = false;

    public EmbeddedElasticsearch(ApplicationPropertiesService applicationPropertiesService, StorageService storageService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.storageService = storageService;
    }

    public void onStart() {
        String version = EmbeddedElasticsearch.getBundledElasticsearchVersion();
        Map<String, Object> settings = this.getElasticsearchSettings();
        Path destination = Paths.get(String.valueOf(settings.get(SETTING_PATH_HOME)), new String[0]);
        EmbeddedElasticsearch.unpackBundleTo(destination);
        String classPath = EmbeddedElasticsearch.createClassPathArg(destination);
        List<String> jvmOptions = EmbeddedElasticsearch.readDefaultJvmOptions(destination);
        String javaHome = System.getProperty("java.home");
        ArrayList<String> args = new ArrayList<String>((Collection<String>)ImmutableList.of((Object)Paths.get(javaHome, new String[0]).resolve(JAVA_EXECUTABLE_PATH).toString(), (Object)"-cp", (Object)classPath));
        args.addAll(jvmOptions);
        args.add(ES_MAIN_CLASS);
        if (!log.isDebugEnabled()) {
            args.add("-q");
        }
        args.addAll(settings.entrySet().stream().flatMap(entry -> Stream.of("-E", (String)entry.getKey() + "=" + entry.getValue())).collect(Collectors.toList()));
        log.info("Starting Elasticsearch {} on ports: {}/http, {}/tcp...", new Object[]{version, settings.get(SETTING_HTTP_PORT), settings.get(SETTING_TCP_PORT)});
        log.debug("Starting Elasticsearch with args: {}", args);
        this.startExecutorService();
        try {
            this.proc = EmbeddedElasticsearch.startProcess(args);
            this.startLogger(this.proc.getInputStream());
            this.startProcessReaper(this.proc);
            EmbeddedElasticsearch.waitUntilStarted(settings);
            log.info("Started Elasticsearch successfully.");
        }
        catch (IOException e) {
            this.stop();
            throw new RuntimeException("Could not start Elasticsearch", e);
        }
        catch (IllegalStateException e) {
            this.stop();
            throw e;
        }
    }

    public void onStop() {
        this.stop();
    }

    private static String createClassPathArg(Path destination) {
        String classPath;
        try {
            classPath = Files.walk(destination.resolve(ES_LIB_PATH), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(String::valueOf).collect(Collectors.joining(File.pathSeparator));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not list files for classpath argument", e);
        }
        return classPath;
    }

    private static String getBundledElasticsearchVersion() {
        try {
            Properties props = new Properties();
            props.load(new ClassPathResource("elasticsearch.properties", EmbeddedElasticsearch.class.getClassLoader()).getInputStream());
            return String.valueOf(props.get("elasticsearch.version"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load Elasticsearch version", e);
        }
    }

    private static List<String> readDefaultJvmOptions(Path destination) {
        try {
            return Files.lines(destination.resolve(ES_JVM_OPTIONS_PATH)).map(s -> LINE_COMMENT_PATTERN.matcher((CharSequence)s).replaceAll("")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get JVM options", e);
        }
    }

    private static Process startProcess(List<String> args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        return builder.start();
    }

    private static void unpackBundleTo(Path destination) {
        try (InputStream inputStream = new ClassPathResource(ES_BUNDLE_RESOURCE, EmbeddedElasticsearch.class.getClassLoader()).getInputStream();
             ZipInputStream zip = new ZipInputStream(inputStream);){
            ZipEntry entry;
            HashSet<Path> unpackedEntries = new HashSet<Path>();
            while ((entry = zip.getNextEntry()) != null) {
                Path entryPath = Paths.get(entry.getName().replace('/', File.separatorChar), new String[0]);
                if (entryPath.getNameCount() <= 1) continue;
                entryPath = entryPath.subpath(1, entryPath.getNameCount());
                Path destinationFile = destination.resolve(entryPath);
                unpackedEntries.add(entryPath);
                if (entry.isDirectory()) {
                    Files.createDirectories(destinationFile, new FileAttribute[0]);
                    continue;
                }
                FileTime lastModifiedTime = null;
                try {
                    lastModifiedTime = Files.getLastModifiedTime(destinationFile, new LinkOption[0]);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
                Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                if (Objects.compare(lastModifiedTime, entry.getLastModifiedTime(), Comparator.nullsFirst(Comparator.naturalOrder())) >= 0) continue;
                Files.copy(zip, destinationFile, new CopyOption[0]);
                Files.setLastModifiedTime(destinationFile, entry.getLastModifiedTime());
            }
            Files.walk(destination, new FileVisitOption[0]).map(destination::relativize).filter(path -> !path.startsWith("data") && !path.startsWith("logs")).filter(path -> !Paths.get("", new String[0]).equals(path)).filter(path -> !unpackedEntries.contains(path)).sorted(Comparator.reverseOrder()).peek(path -> log.debug("Deleting leftover file from previous installation: {}", path)).map(destination::resolve).map(Path::toFile).forEach(file -> {
                boolean delete = file.delete();
                if (!delete) {
                    log.error("Could not delete leftover file {}", file);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not unpack bundle", e);
        }
    }

    private static void waitUntilStarted(Map<String, Object> settings) {
        int port = Integer.parseInt(settings.get(SETTING_HTTP_PORT).toString());
        try {
            String hostName = "localhost";
            Instant start = Instant.now();
            IOException lastError = null;
            while (start.plus(Duration.ofSeconds(45L)).isAfter(Instant.now())) {
                try {
                    Socket ignored = new Socket(hostName, port);
                    Throwable throwable = null;
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    lastError = e;
                    log.debug("Waiting for Elasticsearch to start...");
                    Thread.sleep(1000L);
                }
            }
            throw new IllegalStateException("Timed out waiting for Elasticsearch to start", lastError);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private Path createInstallDirectory() {
        Path directory = this.storageService.getHomeDir().resolve(Paths.get("search", new String[0]));
        try {
            return Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Could not create a directory at {}", (Object)directory, (Object)e);
            throw new RuntimeException("Failed to create directory", e);
        }
    }

    private Map<String, Object> getElasticsearchSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        Supplier<Path> installDirectory = () -> ((com.google.common.base.Supplier)Suppliers.memoize(this::createInstallDirectory)).get();
        this.updateSettingWithOverride(settings, SETTING_PATH_HOME, installDirectory::get);
        this.updateSettingWithOverride(settings, SETTING_PATH_DATA, () -> ((Path)installDirectory.get()).resolve("data"));
        this.updateSettingWithOverride(settings, SETTING_PATH_LOGS, () -> ((Path)installDirectory.get()).resolve("logs"));
        this.updateSettingWithOverride(settings, SETTING_HTTP_PORT, 7992);
        this.updateSettingWithOverride(settings, SETTING_TCP_PORT, 7993);
        this.updateSettingWithOverride(settings, "action.auto_create_index", false);
        this.updateSettingWithOverride(settings, "cluster.routing.allocation.disk.threshold_enabled", false);
        return settings;
    }

    private void startExecutorService() {
        this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"embedded-es", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    private void startLogger(InputStream inputStream) {
        this.executorService.submit(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info("[ES] {}", (Object)line);
                }
            }
            catch (IOException e) {
                log.error("Failed reading log output", (Throwable)e);
            }
        });
    }

    private void startProcessReaper(Process proc) {
        this.executorService.submit(() -> {
            try {
                int code = proc.waitFor();
                if (!this.stopping) {
                    if (code != 0) {
                        log.warn("Elasticsearch exited irregularly - see logs for details.");
                    }
                    this.stopExecutorService();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private void stop() {
        this.stopping = true;
        try {
            this.stopProcess();
            this.stopExecutorService();
        }
        finally {
            this.stopping = false;
        }
    }

    private void stopExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void stopProcess() {
        if (this.proc != null) {
            log.info("Stopping Elasticsearch...");
            try {
                this.proc.destroy();
                if (!this.proc.waitFor(15L, TimeUnit.SECONDS)) {
                    this.proc.destroyForcibly();
                    if (!this.proc.waitFor(15L, TimeUnit.SECONDS)) {
                        log.error("Timed out waiting for Elasticsearch to stop");
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.proc = null;
            }
            log.info("Stopped Elasticsearch successfully.");
        }
    }

    private void updateSettingWithOverride(Map<String, Object> settings, String property, Supplier<Object> defaultValueSupplier) {
        String pluginProperty = PLUGIN_SETTINGS_KEY_PREFIX + property;
        String value = this.applicationPropertiesService.getPluginProperty(pluginProperty);
        if (value == null) {
            String defaultValue = String.valueOf(defaultValueSupplier.get());
            settings.put(property, defaultValue);
            return;
        }
        settings.put(property, value);
    }

    private void updateSettingWithOverride(Map<String, Object> settings, String property, Object defaultValue) {
        this.updateSettingWithOverride(settings, property, () -> defaultValue);
    }
}

