/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search.domain;

import com.atlassian.bitbucket.search.domain.Identifier;
import com.atlassian.bitbucket.search.domain.Project;
import com.atlassian.bitbucket.search.domain.Repository;
import com.atlassian.bitbucket.search.domain.RepositoryContextDefinition;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class SimpleRepositoryContextDefinition
implements RepositoryContextDefinition {
    private final boolean isPublic;
    private final boolean isFork;
    private final Optional<Identifier<Project>> projectId;
    private final Identifier<Repository> repositoryId;

    private SimpleRepositoryContextDefinition(Builder builder) {
        this.repositoryId = Objects.requireNonNull(builder.repositoryId, "repositoryId");
        this.projectId = builder.projectId;
        this.isPublic = builder.isPublic;
        this.isFork = builder.isFork;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RepositoryContextDefinition context) {
        return new Builder(context);
    }

    @Override
    @Nonnull
    public Optional<Identifier<Project>> getProjectId() {
        return this.projectId;
    }

    @Override
    @Nonnull
    public Identifier<Repository> getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean isFork() {
        return this.isFork;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleRepositoryContextDefinition)) {
            return false;
        }
        SimpleRepositoryContextDefinition that = (SimpleRepositoryContextDefinition)o;
        return this.isPublic == that.isPublic && this.isFork == that.isFork && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.repositoryId, that.repositoryId);
    }

    public int hashCode() {
        return Objects.hash(this.isPublic, this.isFork, this.projectId, this.repositoryId);
    }

    public String toString() {
        return "SimpleRepositoryContextDefinition{isPublic=" + this.isPublic + ", isFork=" + this.isFork + ", projectId=" + this.projectId + ", repositoryId=" + this.repositoryId + '}';
    }

    public static final class Builder {
        private boolean isPublic;
        private boolean isFork;
        private Optional<Identifier<Project>> projectId;
        private Identifier<Repository> repositoryId;

        private Builder() {
            this.projectId = Optional.empty();
        }

        public Builder(RepositoryContextDefinition context) {
            this.isPublic = context.isPublic();
            this.projectId = context.getProjectId();
            this.repositoryId = context.getRepositoryId();
            this.projectId = context.getProjectId();
        }

        @Nonnull
        public RepositoryContextDefinition build() {
            return new SimpleRepositoryContextDefinition(this);
        }

        @Nonnull
        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        @Nonnull
        public Builder projectId(@Nonnull Identifier<Project> projectId) {
            this.projectId = Optional.of(Objects.requireNonNull(projectId, "projectId"));
            return this;
        }

        @Nonnull
        public Builder projectId(@Nonnull Optional<Identifier<Project>> projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId");
            return this;
        }

        @Nonnull
        public Builder repositoryId(@Nonnull Identifier<Repository> repositoryId) {
            this.repositoryId = Objects.requireNonNull(repositoryId, "repositoryId");
            return this;
        }

        public Builder isFork(boolean isFork) {
            this.isFork = isFork;
            return this;
        }
    }
}

