/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search.domain;

import com.atlassian.bitbucket.search.domain.Avatar;
import com.atlassian.bitbucket.search.domain.Identifier;
import com.atlassian.bitbucket.search.domain.Project;
import com.atlassian.bitbucket.search.domain.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class SimpleRepository
implements Repository {
    private final Identifier<Repository> id;
    private final String slug;
    private final String name;
    private final boolean isPublic;
    private final boolean isFork;
    private final Optional<Project> project;
    private final Optional<Avatar> avatar;

    private SimpleRepository(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "builder.id");
        this.slug = Objects.requireNonNull(builder.slug, "builder.slug");
        this.name = Objects.requireNonNull(builder.name, "builder.name");
        this.isPublic = builder.isPublic;
        this.isFork = builder.isFork;
        this.project = Objects.requireNonNull(builder.project, "builder.project");
        this.avatar = Objects.requireNonNull(builder.avatar, "builder.avatar");
    }

    @Override
    public Identifier<Repository> getId() {
        return this.id;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<Project> getProject() {
        return this.project;
    }

    @Override
    public Optional<Avatar> getAvatar() {
        return this.avatar;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean isFork() {
        return this.isFork;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleRepository)) {
            return false;
        }
        SimpleRepository that = (SimpleRepository)o;
        return this.isPublic == that.isPublic && this.isFork == that.isFork && Objects.equals(this.id, that.id) && Objects.equals(this.slug, that.slug) && Objects.equals(this.name, that.name) && Objects.equals(this.project, that.project) && Objects.equals(this.avatar, that.avatar);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.slug, this.name, this.project, this.isPublic, this.isFork, this.avatar);
    }

    public String toString() {
        return "SimpleRepository{id=" + this.id + ", slug='" + this.slug + '\'' + ", name='" + this.name + '\'' + ", project=" + this.project + ", isPublic=" + this.isPublic + ", isFork=" + this.isFork + ", avatar=" + this.avatar + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Identifier<Repository> id;
        private String slug;
        private String name;
        private boolean isPublic;
        private boolean isFork;
        private Optional<Project> project = Optional.empty();
        private Optional<Avatar> avatar = Optional.empty();

        @Nonnull
        public Builder id(@Nonnull Identifier<Repository> id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @Nonnull
        public Builder slug(@Nonnull String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @Nonnull
        public Builder project(@Nonnull Project project) {
            this.project = Optional.of(Objects.requireNonNull(project, "project"));
            return this;
        }

        @Nonnull
        public Builder avatar(@Nonnull Avatar avatar) {
            this.avatar = Optional.of(Objects.requireNonNull(avatar, "avatar"));
            return this;
        }

        @Nonnull
        public Builder avatar(@Nonnull Optional<Avatar> avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @Nonnull
        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        @Nonnull
        public Builder isFork(boolean isFork) {
            this.isFork = isFork;
            return this;
        }

        @Nonnull
        public SimpleRepository build() {
            return new SimpleRepository(this);
        }
    }
}

