define("hipchat/invite/bitbucket-ui", [
    'jquery',
    'hipchat/invite/user-picker',
    'bitbucket/util/navbuilder',
    'exports'
],
function (
    $,
    inviteUserPicker,
    navbuilder,
    exports
) {
    'use strict';

    /**
     * Returns params that should be added to the request for the list of users.
     *
     * @param {String} filter - A filter to apply to the user search
     * @returns {{avatarSize: number, filter: *, limit: number}}
     */
    function makeParams(filter) {
        return {
            avatarSize: 48,
            filter: filter,
            limit: 10
        };
    }

    /**
     * Processes the results returned from the server so they can be displayed.
     *
     * @param {Object} data - The data returned from the server.
     * @returns {{results: (Array|*)}} - An array of objects ready to be displayed.
     */
    function processResults(data) {
        var results = data.values.map(function(item) {
            return {
                id: item.slug,
                text: item.displayName,
                username: item.slug,
                fullname: item.displayName,
                avatarUrl: item.avatarUrl,
                email: item.emailAddress
            };
        });
        return {
            results: results
        };
    }

    /**
     * Initialises the invite form and setups the functions that will process the user list results.
     */
    function init() {
        var $form = $('#hipchat-invite-form');
        var $userField = $form.find('#hipchat-invite-user');

        inviteUserPicker($userField, $form, {
            url: navbuilder.rest().users().build(),
            params: makeParams,
            results: processResults,
            choice: function (item) { return item; }
        });
    }

    exports.init = init;
});

jQuery(document).ready(function() {
    require("hipchat/invite/bitbucket-ui").init();
});
