/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest;

import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfigurationService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationSearchRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest.RestRepositoryConfiguration;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="global-notifications")
@Singleton
public class GlobalNotificationConfigurationResource
extends RestResource {
    private final NotificationConfigurationService notificationConfigService;

    public GlobalNotificationConfigurationResource(I18nService i18nService, NotificationConfigurationService notificationConfigService) {
        super(i18nService);
        this.notificationConfigService = notificationConfigService;
    }

    @GET
    public Response notifications(@Context PageRequest pageRequest) {
        NotificationSearchRequest request = new NotificationSearchRequest.Builder().build();
        Page<RepositoryConfiguration> repoConfigPage = this.notificationConfigService.search(request, pageRequest);
        return ResponseFactory.ok().entity((Object)new RestPage(repoConfigPage, RestRepositoryConfiguration::new)).build();
    }
}

