/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.hipchat.notification.NotificationTypeService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfigurationService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationSearchRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugins.hipchat.api.link.ConnectDescriptorLoader;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;

public class NotificationConfigurationContextBuilder {
    private static final String PLUGIN_PREFIX = "plugin.bitbucket-hipchat-integration.";
    private static final String PROPERTY_PAGE_SIZE_LIMIT = "plugin.bitbucket-hipchat-integration.hipchat.config.page-size";
    private final int pageSizeLimit;
    private final ConnectDescriptorLoader connectDescriptorLoader;
    private final HipChatLinkProvider hipChatLinkProvider;
    private final HipChatUserFinder hipChatUserFinder;
    private final NavBuilder navBuilder;
    private final NotificationConfigurationService notificationConfigService;
    private final NotificationTypeService notificationTypeService;
    private final UserManager userManager;

    public NotificationConfigurationContextBuilder(ConnectDescriptorLoader connectDescriptorLoader, HipChatLinkProvider hipChatLinkProvider, HipChatUserFinder hipChatUserFinder, NavBuilder navBuilder, NotificationConfigurationService notificationConfigService, NotificationTypeService notificationTypeService, ApplicationPropertiesService propertiesService, UserManager userManager) {
        this.connectDescriptorLoader = connectDescriptorLoader;
        this.navBuilder = navBuilder;
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.hipChatUserFinder = hipChatUserFinder;
        this.notificationConfigService = notificationConfigService;
        this.notificationTypeService = notificationTypeService;
        this.userManager = userManager;
        this.pageSizeLimit = propertiesService.getPluginProperty(PROPERTY_PAGE_SIZE_LIMIT, 25);
    }

    public ImmutableMap.Builder<String, Object> addHipChatViewContext(ImmutableMap.Builder<String, Object> contextBuilder) {
        Option hipChatLink = this.hipChatLinkProvider.getDefaultLink();
        hipChatLink.forEach(link -> {
            contextBuilder.put((Object)"groupName", (Object)link.getGroupName()).put((Object)"hipChatApiUrl", (Object)link.getApiUrl());
            this.putHipChatUser(contextBuilder);
        });
        return contextBuilder;
    }

    public ImmutableMap.Builder<String, Object> createGlobalViewContext() {
        NotificationSearchRequest searchRequest = new NotificationSearchRequest.Builder().build();
        return this.createViewContext(searchRequest);
    }

    public ImmutableMap.Builder<String, Object> createRepositoryViewContext(Repository repository) {
        NotificationSearchRequest searchRequest = ((NotificationSearchRequest.Builder)((Object)new NotificationSearchRequest.Builder().repository(repository))).build();
        ImmutableMap.Builder<String, Object> contextBuilder = this.createViewContext(searchRequest);
        contextBuilder.put((Object)"repository", (Object)repository);
        this.hipChatLinkProvider.getDefaultLink().foreach(hipChatLink -> {
            Option connectDescriptor = this.connectDescriptorLoader.loadConnectDescriptor(hipChatLink.getId());
            connectDescriptor.foreach(descriptor -> {
                String currentBaseUrl;
                String configuredSelfLink = descriptor.getSelfLink().toString();
                if (!configuredSelfLink.equals(currentBaseUrl = this.navBuilder.buildBaseUrl())) {
                    contextBuilder.put((Object)"configuredSelfLink", (Object)configuredSelfLink);
                    contextBuilder.put((Object)"expectedUrl", (Object)this.expectedUrl(configuredSelfLink, repository));
                    contextBuilder.put((Object)"currentBaseUrl", (Object)currentBaseUrl);
                    contextBuilder.put((Object)"loginError", (Object)true);
                }
            });
        });
        return contextBuilder;
    }

    public ImmutableMap.Builder<String, Object> putHipChatUser(ImmutableMap.Builder<String, Object> contextBuilder) {
        Option hipChatUser;
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && !(hipChatUser = this.hipChatUserFinder.findHipChatUserIdAndName(user.getUserKey())).isEmpty()) {
            contextBuilder.put((Object)"hipChatUserName", ((Pair)hipChatUser.get()).right());
        }
        return contextBuilder;
    }

    private ImmutableMap.Builder<String, Object> createViewContext(NotificationSearchRequest searchRequest) {
        ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
        HashMap<String, List> categories = new HashMap<String, List>();
        for (NotificationType notificationType : this.notificationTypeService.getAll()) {
            String category = notificationType.getCategory();
            List notificationTypes = (List)categories.get(category);
            if (notificationTypes == null) {
                notificationTypes = Lists.newArrayList();
                categories.put(category, notificationTypes);
            }
            notificationTypes.add(notificationType);
        }
        contextBuilder.put((Object)"categories", categories);
        Page<RepositoryConfiguration> repoConfigs = this.notificationConfigService.search(searchRequest, (PageRequest)new PageRequestImpl(0, this.pageSizeLimit));
        contextBuilder.put((Object)"configsPage", repoConfigs);
        return contextBuilder;
    }

    private String expectedUrl(String configuredSelfLink, Repository repository) {
        return configuredSelfLink + "/plugins/servlet/repo-hipchat-settings/projects/" + repository.getProject().getKey() + "/repos/" + repository.getSlug();
    }
}

