/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.InviteUsersService;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugins.hipchat.user.UserReference;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultInviteUsersService
implements InviteUsersService {
    private static final int MAX_PREFILLED_USERS = 10;
    private AvatarService avatarService;
    private UserAdminService userAdminService;

    public DefaultInviteUsersService(AvatarService avatarService, UserAdminService userAdminService) {
        this.avatarService = avatarService;
        this.userAdminService = userAdminService;
    }

    @Override
    public Set<UserReference> getUserList(boolean secureAvatars) {
        Page users = this.userAdminService.findUsers((PageRequest)new PageRequestImpl(0, 100));
        return MoreStreams.streamIterable((Iterable)users.getValues()).filter(user -> user.isActive() && StringUtils.isNotEmpty((CharSequence)user.getEmailAddress()) && user.getLastAuthenticationTimestamp() != null).sorted(Comparator.comparing(DetailedUser::getLastAuthenticationTimestamp)).map(user -> {
            String avatarURI = this.avatarService.getUrlForPerson((Person)user, new AvatarRequest(secureAvatars, 48));
            return new UserReference(user.getSlug(), user.getName(), user.getEmailAddress(), user.getDisplayName(), avatarURI);
        }).limit(10L).collect(Collectors.toSet());
    }
}

