/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.internal.hipchat.notification.configuration.AbstractNotificationRequest;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;

public class AbstractNotificationUpdateRequest
extends AbstractNotificationRequest {
    private final Iterable<NotificationType> notificationTypes;
    private final Option<String> roomId;

    protected AbstractNotificationUpdateRequest(AbstractUpdateBuilder builder) {
        super(builder);
        this.notificationTypes = builder.notificationTypes;
        this.roomId = builder.roomId;
    }

    @Nonnull
    public Iterable<NotificationType> getNotificationTypes() {
        return this.notificationTypes;
    }

    @Nonnull
    public Option<String> getRoomId() {
        return this.roomId;
    }

    public static abstract class AbstractUpdateBuilder<B extends AbstractNotificationRequest.AbstractBuilder<B>>
    extends AbstractNotificationRequest.AbstractBuilder<B> {
        protected Set<NotificationType> notificationTypes = Sets.newHashSet();
        protected Option<String> roomId = Option.none();

        @Nonnull
        public AbstractNotificationUpdateRequest build() {
            return new AbstractNotificationUpdateRequest(this);
        }

        @Nonnull
        public B notificationType(@Nonnull NotificationType value) {
            this.notificationTypes.add((NotificationType)Preconditions.checkNotNull((Object)value, (Object)"notification type"));
            return this.self();
        }

        @Nonnull
        public B notificationTypes(@Nonnull Iterable<NotificationType> values) {
            this.notificationTypes.addAll(Sets.newHashSet((Iterable)((Iterable)Preconditions.checkNotNull(values, (Object)"notification types"))));
            return this.self();
        }

        @Nonnull
        public B roomId(@Nonnull String value) {
            this.roomId = Option.some((Object)AbstractUpdateBuilder.checkNotBlank((String)value, (String)"roomId"));
            return this.self();
        }

        protected void validate(Option value, String errorMessage) {
            Preconditions.checkState((boolean)value.isDefined(), (Object)errorMessage);
        }
    }
}

