/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification;

import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class RoomNotification {
    private final String message;
    private final HipChatNotificationOptions options;
    private final String roomId;

    private RoomNotification(Builder builder) {
        this.message = builder.message;
        this.options = builder.options;
        this.roomId = builder.roomId;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public HipChatNotificationOptions getOptions() {
        return this.options;
    }

    @Nonnull
    public String getRoomId() {
        return this.roomId;
    }

    public static class Builder {
        private String message;
        private HipChatNotificationOptions options;
        private String roomId;

        @Nonnull
        public RoomNotification build() {
            Preconditions.checkState((this.message != null ? 1 : 0) != 0, (Object)"A message must be supplied");
            Preconditions.checkState((this.options != null ? 1 : 0) != 0, (Object)"Options must be supplied");
            Preconditions.checkState((this.roomId != null ? 1 : 0) != 0, (Object)"A roomId must be supplied");
            return new RoomNotification(this);
        }

        @Nonnull
        public Builder message(@Nonnull String value) {
            this.message = (String)Preconditions.checkNotNull((Object)value, (Object)"message");
            return this;
        }

        @Nonnull
        public Builder options(@Nonnull HipChatNotificationOptions value) {
            this.options = (HipChatNotificationOptions)Preconditions.checkNotNull((Object)value, (Object)"options");
            return this;
        }

        @Nonnull
        public Builder roomId(@Nonnull String value) {
            this.roomId = (String)Preconditions.checkNotNull((Object)value, (Object)"roomId");
            return this;
        }
    }
}

