/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hipchat.notification;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.hipchat.notification.RepositoryNotificationUpdatedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class RepositoryNotificationUpdatedEventConverter
implements AuditEntryConverter<RepositoryNotificationUpdatedEvent> {
    @Nonnull
    public AuditEntry convert(@Nonnull RepositoryNotificationUpdatedEvent event, AuditEntryBuilder builder) {
        HashMap payload = Maps.newHashMap();
        payload.put("room-id", event.getRoomId());
        payload.put("updated-notifications", event.getNotificationTypes().stream().map(NotificationType::getKey).collect(Collectors.toList()));
        try {
            return builder.action(((Object)((Object)event)).getClass()).timestamp(new Date()).details(AuditUtils.toJSONString((Map)payload)).user(event.getUser()).target(AuditUtils.toProjectAndRepositoryString((Repository)event.getRepository())).repository(event.getRepository()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to convert map %s to JSON", payload), e);
        }
    }
}

