/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.parser;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TestResults {
    private static final long UNKNOWN_DURATION = -1L;
    private static final String UNNAMED_TEST_SUITE = "unnamed test suite";
    private final String myClassName;
    private final long myDuration;
    private final String myName;
    private boolean failed = false;
    private boolean hasErrors = false;

    public TestResults(String className, String methodName, String stringDuration) {
        this.myClassName = StringUtils.isEmpty((CharSequence)className) ? UNNAMED_TEST_SUITE : className;
        double duration = 0.0;
        try {
            duration = NumberUtils.createDouble((String)stringDuration);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.myDuration = (long)(duration * 1000.0);
        this.myName = methodName;
    }

    public String getActualMethodName() {
        return this.myName;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public long getDurationMs() {
        return this.myDuration == -1L ? 0L : this.myDuration;
    }

    public String getShortClassName() {
        if (StringUtils.contains((CharSequence)this.myClassName, (CharSequence)".")) {
            return StringUtils.substringAfterLast((String)this.myClassName, (String)".");
        }
        return this.myClassName;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = true;
    }

    public void setHasError() {
        this.hasErrors = true;
    }

    public String toString() {
        return "TestResults{myName='" + this.myName + '\'' + ", myClassName='" + this.myClassName + '\'' + ", myDuration=" + this.myDuration + '}';
    }
}

