/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.parser;

import com.atlassian.bitbucket.codeinsights.InsightAnnotation;
import com.atlassian.bitbucket.codeinsights.ParseResults;
import com.atlassian.bitbucket.codeinsights.parser.DefaultContentHandler;
import com.atlassian.bitbucket.codeinsights.parser.DefaultElementParser;
import com.atlassian.bitbucket.codeinsights.parser.ElementContentElementParser;
import com.atlassian.bitbucket.codeinsights.parser.TestResults;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JunitTestResultsParser
extends DefaultContentHandler {
    private static final String TESTNG_SUPERFLOUS_TEXT_START = "on instance";
    private String basePath;
    private TestResults currentTestResult;
    private boolean isIgnoredTest = false;
    private String suiteClassName;
    private Logger log;
    private ParseResults parseResults;

    public JunitTestResultsParser(Logger logger, MavenProject project, String basePath, ParseResults parseResults) {
        this.registerElementParser("testsuite", new TestSuiteElementParser());
        this.registerElementParser("testcase", new TestCaseElementParser(false));
        this.registerElementParser("error", new ErrorParser(project));
        this.registerElementParser("failure", new FailureParser(project));
        this.registerElementParser("skipped", new SkippedElementParser());
        this.basePath = basePath;
        this.parseResults = parseResults;
        this.log = logger;
    }

    public String toString() {
        return "JunitTestResultsParser{basePath='" + this.basePath + '\'' + ", currentTestResult=" + this.currentTestResult + ", isIgnoredTest=" + this.isIgnoredTest + ", suiteClassName='" + this.suiteClassName + '\'' + '}';
    }

    public static Reader sanitiseXml10Reader(Reader in) {
        final PushbackReader pushbackReader = new PushbackReader(new BufferedReader(in));
        return new FilterReader(pushbackReader){
            int nextWithoutFiltering;
            {
                super(x0);
                this.nextWithoutFiltering = -1;
            }

            @Override
            public int read() throws IOException {
                int codePoint;
                do {
                    if (this.nextWithoutFiltering != -1) {
                        int c = this.nextWithoutFiltering;
                        this.nextWithoutFiltering = -1;
                        return c;
                    }
                    codePoint = this.readCodePoint();
                    if (codePoint != -1) continue;
                    return -1;
                } while (!JunitTestResultsParser.validXml10(codePoint));
                if (Character.charCount(codePoint) == 2) {
                    char[] pair = Character.toChars(codePoint);
                    this.nextWithoutFiltering = pair[1];
                    return pair[0];
                }
                return codePoint;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    int c = this.read();
                    if (c == -1) {
                        if (i == 0) {
                            return -1;
                        }
                        return i;
                    }
                    cbuf[off + i] = (char)c;
                }
                return len;
            }

            private int readCodePoint() throws IOException {
                int firstChar = pushbackReader.read();
                if (firstChar < 0 || !Character.isHighSurrogate((char)firstChar)) {
                    return firstChar;
                }
                int secondChar = pushbackReader.read();
                if (secondChar == -1) {
                    return firstChar;
                }
                if (!Character.isLowSurrogate((char)secondChar)) {
                    pushbackReader.unread(secondChar);
                    return firstChar;
                }
                return Character.toCodePoint((char)firstChar, (char)secondChar);
            }
        };
    }

    public static boolean validXml10(int codePoint) {
        return codePoint >= 32 && codePoint <= 55295 || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public void parse(InputStream inputStream) throws SAXException, IOException {
        this.parse(new InputStreamReader(inputStream));
    }

    public void parse(Reader inputReader) throws SAXException, IOException {
        XMLReader reader = SecureXmlParserFactory.newNamespaceAwareXmlReader();
        reader.setContentHandler(this);
        reader.parse(new InputSource(JunitTestResultsParser.sanitiseXml10Reader(inputReader)));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.hasParserFor(localName)) {
            this.registerElementParser(localName, DefaultElementParser.getInstance());
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private class FailureParser
    extends ElementWithStacktraceContentParser {
        public FailureParser(MavenProject project) {
            super(project);
        }

        @Override
        public void startElement(Attributes attributes) {
            JunitTestResultsParser.this.parseResults.addTestFail();
            JunitTestResultsParser.this.currentTestResult.setFailed();
            super.startElement(attributes);
        }
    }

    private class ErrorParser
    extends ElementWithStacktraceContentParser {
        public ErrorParser(MavenProject project) {
            super(project);
        }

        @Override
        public void startElement(Attributes attributes) {
            JunitTestResultsParser.this.currentTestResult.setHasError();
            JunitTestResultsParser.this.parseResults.addTestInError();
            super.startElement(attributes);
        }
    }

    class TestSuiteElementParser
    extends DefaultElementParser {
        TestSuiteElementParser() {
        }

        @Override
        public void startElement(Attributes attributes) {
            JunitTestResultsParser.this.suiteClassName = attributes.getValue("name");
        }
    }

    class TestCaseElementParser
    extends DefaultElementParser {
        private final boolean ignoreNamedInnerClass;

        TestCaseElementParser(boolean ignoreNamedInnerClass) {
            this.ignoreNamedInnerClass = ignoreNamedInnerClass;
        }

        @Override
        public void endElement() {
            if (JunitTestResultsParser.this.isIgnoredTest) {
                JunitTestResultsParser.this.isIgnoredTest = false;
            } else if (!JunitTestResultsParser.this.currentTestResult.hasErrors() && !JunitTestResultsParser.this.currentTestResult.isFailed()) {
                JunitTestResultsParser.this.parseResults.addTestsPass();
            }
            JunitTestResultsParser.this.parseResults.addToTotalDuration(JunitTestResultsParser.this.currentTestResult.getDurationMs());
            JunitTestResultsParser.this.currentTestResult = null;
        }

        @Override
        public void startElement(Attributes attributes) {
            String className;
            String testName = attributes.getValue("name");
            String testDuration = attributes.getValue("time");
            if (testName.contains(JunitTestResultsParser.TESTNG_SUPERFLOUS_TEXT_START)) {
                testName = testName.substring(0, testName.indexOf(JunitTestResultsParser.TESTNG_SUPERFLOUS_TEXT_START)).trim();
            }
            if ((className = attributes.getValue("classname")) == null) {
                className = JunitTestResultsParser.this.suiteClassName;
            } else if (className.contains("$") && this.ignoreNamedInnerClass) {
                className = JunitTestResultsParser.this.suiteClassName;
            } else if (this.isInnerClassAnonymous(className)) {
                className = JunitTestResultsParser.this.suiteClassName;
            }
            JunitTestResultsParser.this.currentTestResult = new TestResults(className, testName, testDuration);
        }

        private boolean isInnerClassAnonymous(String className) {
            return NumberUtils.isNumber((String)StringUtils.substringAfterLast((String)className, (String)"$"));
        }
    }

    class SkippedElementParser
    extends DefaultElementParser {
        SkippedElementParser() {
        }

        @Override
        public void startElement(Attributes attributes) {
            JunitTestResultsParser.this.isIgnoredTest = true;
            JunitTestResultsParser.this.parseResults.addSkippedTests();
        }
    }

    class ElementWithStacktraceContentParser
    extends ElementContentElementParser {
        private String message;
        private MavenProject project;
        private String type;

        public ElementWithStacktraceContentParser(MavenProject project) {
            this.project = project;
        }

        @Override
        public void endElement() {
            String content = this.getElementContent();
            String[] stackElements = content.split("\n");
            boolean found = false;
            int element = 0;
            File file = null;
            while (!found && element < stackElements.length) {
                File f = this.findFile(this.project, stackElements[element]);
                if (f != null) {
                    found = true;
                    file = f;
                    continue;
                }
                ++element;
            }
            if (found) {
                try {
                    String relativePath = file.getCanonicalPath();
                    relativePath = relativePath.substring(JunitTestResultsParser.this.basePath.length() + 1);
                    if (this.message == null) {
                        this.message = stackElements[0];
                    }
                    if (JunitTestResultsParser.this.currentTestResult != null) {
                        this.message = "Test - " + JunitTestResultsParser.this.currentTestResult.getActualMethodName() + " - " + this.message;
                    }
                    relativePath = relativePath.replace("\\", "/");
                    JunitTestResultsParser.this.parseResults.addAnnotation(new InsightAnnotation(this.extractLineNumber(stackElements[element]), this.message, relativePath));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.message = null;
            this.type = null;
        }

        @Override
        public void startElement(Attributes attributes) {
            super.startElement(attributes);
            this.message = attributes.getValue("message");
            this.type = attributes.getValue("type");
        }

        private String constructFQN(String stackElement, int colonPos, int paranPos) {
            int dotIndex;
            String partialPath = stackElement.substring(4, paranPos);
            if (partialPath.contains("$")) {
                partialPath = partialPath.substring(0, partialPath.indexOf("$"));
            }
            if ((dotIndex = partialPath.lastIndexOf(".")) == -1) {
                return stackElement;
            }
            if (!stackElement.contains("$")) {
                partialPath = partialPath.substring(0, dotIndex);
            }
            return partialPath + "." + stackElement.substring(stackElement.lastIndexOf(".") + 1, colonPos);
        }

        private int extractLineNumber(String stackElement) {
            int lineNumber = -1;
            try {
                int colonPos = stackElement.lastIndexOf(":");
                int parenPos = stackElement.lastIndexOf(")");
                if (colonPos == -1 || parenPos == -1) {
                    return -1;
                }
                lineNumber = Integer.parseInt(stackElement.substring(colonPos + 1, parenPos));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return lineNumber;
        }

        private File findFile(MavenProject project, String stackElement) {
            int paranPos = stackElement.lastIndexOf("(");
            if (paranPos == -1) {
                return null;
            }
            int colonPos = stackElement.lastIndexOf(":");
            if (colonPos == -1 || !stackElement.contains(".")) {
                return null;
            }
            String fqn = this.constructFQN(stackElement, colonPos, paranPos);
            String fqp = this.transformToPath(fqn);
            JunitTestResultsParser.this.log.debug(String.format("Translated '%s' to path '%s'", stackElement, fqp));
            File f = new File(project.getBuild().getSourceDirectory(), fqp);
            JunitTestResultsParser.this.log.debug(String.format("Looking in '%s' for file", project.getBuild().getSourceDirectory()));
            if (f.exists()) {
                return f;
            }
            f = new File(project.getBuild().getTestSourceDirectory(), fqp);
            JunitTestResultsParser.this.log.debug(String.format("Looking in '%s' for file", project.getBuild().getTestSourceDirectory()));
            if (f.exists()) {
                return f;
            }
            return null;
        }

        private String transformToPath(String fqn) {
            String path = fqn.substring(0, fqn.lastIndexOf(".")).replace(".", "/");
            return path + fqn.substring(fqn.lastIndexOf("."), fqn.length());
        }
    }
}

