/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights;

import com.atlassian.bitbucket.codeinsights.BitbucketClient;
import com.atlassian.bitbucket.codeinsights.ParseResults;
import com.atlassian.bitbucket.codeinsights.parser.JunitTestResultsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.xml.sax.SAXException;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="code insights")
public class PostingExtension
extends AbstractMavenLifecycleParticipant {
    private final String REPORT_KEY_PROPERTY = "insightsReportKey";
    private final String REPORT_TITLE_PROPERTY = "insightsReportTitle";
    private final String COMMIT_HASH_PROPERTY = "insightsCommitHash";
    private final String FAIL_BUILD = "insightsFailBuild";
    private final String PARSE_FAILSAFE_PROPERY = "insigthsParseFailsafeResults";
    private final String PARSE_SUREFIRE_PROPERY = "insigthsParseSurefireResults";
    private final String POST_ANNOTATION_LIMIT = "insightsMaxAnnotations";
    private final String POST_TO_SERVER_PROPERTY = "insightsPost";
    private final String PROJECT_KEY_PROPERTY = "insightsProjectKey";
    private final String REPOSITORY_PROPERTY = "insightsRepository";
    private final String RETRIES_ON_SERVER_ERROR_PROPERTY = "insightsPostRetryCount";
    private final String SERVER_BASE_URL_PROPERTY = "insightsServerBaseUrl";
    private final String TEST_REPORTS_DIRCTORY_PROPERTY = "insightsCustomReportDirectory";
    private final String TOKEN_PROPERTY = "insightsToken";
    private final String TO_FILE_PROPERTY = "insightsWriteInsigthstoFile";
    private final String WAIT_BETWEEN_RETRIES_PROPERTY = "insightsWaitInterval";
    @Requirement
    private Logger log;
    private MavenProject project;
    private String resultsDirectory;

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        block9: {
            try {
                boolean postToServer = Boolean.parseBoolean(this.getProperty(session, "insightsPost", "true"));
                boolean writeToFile = Boolean.parseBoolean(this.getProperty(session, "insightsWriteInsigthstoFile", "false"));
                int maxAnnotationsToPost = Integer.parseInt(this.getProperty(session, "insightsMaxAnnotations", "1000"));
                int retries = Integer.parseInt(this.getProperty(session, "insightsPostRetryCount", "1"));
                long waitTime = Long.parseLong(this.getProperty(session, "insightsWaitInterval", "10")) * 1000L;
                if (!postToServer && !writeToFile) {
                    this.log.debug("Not parsing, as neither to file nor post to server were defined as true");
                    return;
                }
                this.log.info("Parsing test results for posting to Bitbucket Server");
                this.project = session.getTopLevelProject();
                ArrayList<ParseResults> allResults = new ArrayList<ParseResults>();
                if (this.getProperty(session, "insigthsParseSurefireResults", "true").equalsIgnoreCase("true")) {
                    this.log.info("Parsing surefire reports");
                    this.resultsDirectory = this.getProperty(session, "insightsCustomReportDirectory", "surefire-reports");
                    session.getProjects().stream().map(this::parseResults).filter(ParseResults::isNotEmpty).forEach(allResults::add);
                }
                if (this.getProperty(session, "insigthsParseFailsafeResults", "true").equalsIgnoreCase("true")) {
                    this.log.info("Parsing failsafe reports");
                    this.resultsDirectory = this.getProperty(session, "insightsCustomReportDirectory", "failsafe-reports");
                    session.getProjects().stream().map(this::parseResults).filter(ParseResults::isNotEmpty).forEach(allResults::add);
                }
                ParseResults results = new ParseResults(allResults);
                BitbucketClient client = new BitbucketClient(this.log, this.getProperty(session, "insightsReportKey", "test.results"), this.getProperty(session, "insightsReportTitle", "Test results"), this.getProperty(session, "insightsCommitHash"), maxAnnotationsToPost, this.getProperty(session, "insightsProjectKey"), this.getProperty(session, "insightsRepository"), retries, this.getProperty(session, "insightsServerBaseUrl"), this.getProperty(session, "insightsToken"), waitTime);
                if (postToServer) {
                    client.postResults(results);
                } else {
                    this.log.info(String.format("Not posting to server as property '%s' is set to false", "insightsPost"));
                }
                if (writeToFile) {
                    client.writeToFile(new File(this.project.getBuild().getDirectory()), results);
                } else {
                    this.log.info(String.format("Not writing to file as property '%s' is set to false", "insightsWriteInsigthstoFile"));
                }
            }
            catch (Exception e) {
                this.log.info("Inisghts parsing/posting failed" + e);
                if (!Boolean.parseBoolean(this.getProperty(session, "insightsFailBuild", "false"))) break block9;
                throw new MavenExecutionException("Code insigths failed", (Throwable)e);
            }
        }
    }

    private String getProperty(MavenSession session, String propertyKey) {
        return this.getProperty(session, propertyKey, "");
    }

    private String getProperty(MavenSession session, String propertyKey, String defaultValue) {
        Properties projectProperties = session.getTopLevelProject().getModel().getProperties();
        Properties systemProperties = session.getSystemProperties();
        Properties userProperties = session.getUserProperties();
        String value = userProperties.getProperty(propertyKey);
        if (value == null) {
            value = systemProperties.getProperty(propertyKey);
        }
        if (value == null && (value = projectProperties.getProperty(propertyKey, defaultValue)).contains("${")) {
            value = defaultValue;
        }
        return value;
    }

    private ParseResults parseResults(MavenProject projectToParse) {
        ParseResults parseResults = new ParseResults();
        this.log.debug("Starting parsing of results from " + projectToParse.getName());
        File sureFireDirectory = new File(projectToParse.getBuild().getDirectory(), this.resultsDirectory);
        if (sureFireDirectory.exists()) {
            File[] filesToParse = sureFireDirectory.listFiles((dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".xml"));
            if (filesToParse == null) {
                return parseResults;
            }
            try {
                JunitTestResultsParser parser = new JunitTestResultsParser(this.log, projectToParse, this.project.getBasedir().getCanonicalPath(), parseResults);
                for (File file : filesToParse) {
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        parser.parse(inputStream);
                    }
                }
            }
            catch (IOException | SAXException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.log.debug("No reports found for " + projectToParse.getName());
        }
        return parseResults;
    }
}

