/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.db;

import com.atlassian.beehive.core.stats.StatisticsKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

class StatisticsHolder {
    public static final List<StatisticsKey> TIMESTAMPED_EVENTS_KEYS = ImmutableList.of((Object)StatisticsKey.LAST_LOCK, (Object)StatisticsKey.LAST_FAIL_REMOTE, (Object)StatisticsKey.LAST_ERROR, (Object)StatisticsKey.LAST_STATE_ERROR, (Object)StatisticsKey.LAST_RENEWAL, (Object)StatisticsKey.LAST_UNLOCK);
    private final StatEvent unlock = new StatEvent();
    private final StatEvent lock = new StatEvent();
    private final StatEvent failByRemote = new StatEvent();
    private final StatEvent error = new StatEvent();
    private final StatEvent stateError = new StatEvent();
    private final AtomicLong failLocal = new AtomicLong();
    private final AtomicLong forcedUnlock = new AtomicLong();
    private final AtomicLong totalHoldTimeMillis = new AtomicLong();
    private final AtomicLong totalWaitTimeMillis = new AtomicLong();
    private final AtomicLong totalWaits = new AtomicLong();
    private final AtomicInteger waitQueueLength = new AtomicInteger();
    private final AtomicLong lastRenewalAt = new AtomicLong();

    StatisticsHolder() {
    }

    private static void addAverageStat(ImmutableMap.Builder<StatisticsKey, Long> stats, StatisticsKey key, Number total, Number eventCount) {
        long avg;
        long events = eventCount.longValue();
        if (events > 0L && (avg = total.longValue() / events) > 0L) {
            stats.put((Object)key, (Object)avg);
        }
    }

    public static String getStatisticsSummary(Map<StatisticsKey, Long> currentStatistics, Long currentTime) {
        String operationsPart = TIMESTAMPED_EVENTS_KEYS.stream().filter(k -> currentStatistics.containsKey(k) && (Long)currentStatistics.get(k) > 0L).sorted(Comparator.comparingLong(currentStatistics::get).reversed()).map(k -> k.getLabel() + " " + (currentTime - (Long)currentStatistics.get(k)) + "ms ago").collect(Collectors.joining(", "));
        String statsPart = currentStatistics.keySet().stream().filter(k -> !TIMESTAMPED_EVENTS_KEYS.contains(k)).filter(k -> (Long)currentStatistics.get(k) > 0L).map(k -> k.getLabel() + "=" + currentStatistics.get(k) + "").collect(Collectors.joining(", "));
        StringBuffer buffer = new StringBuffer("Last events on this node at ");
        buffer.append(currentTime);
        buffer.append(": [");
        buffer.append(operationsPart);
        buffer.append("] Lock statistics: [");
        buffer.append(statsPart);
        buffer.append("]");
        return buffer.toString();
    }

    void tallyFailLocal() {
        this.failLocal.incrementAndGet();
    }

    void tallyFailRemote(Long timestamp) {
        this.failByRemote.onEvent(timestamp);
    }

    void tallyForcedUnlock() {
        this.forcedUnlock.incrementAndGet();
    }

    void tallyError(long timestamp) {
        this.error.onEvent(timestamp);
    }

    void tallyStateError(long timestamp) {
        this.stateError.onEvent(timestamp);
    }

    Map<StatisticsKey, Long> getStatistics() {
        ImmutableMap.Builder stats = ImmutableMap.builder();
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.FAIL_LOCAL, this.failLocal);
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.FAIL_REMOTE, this.failByRemote.getEventCount());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_FAIL_REMOTE, this.failByRemote.getLastEventAt());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.FORCED_UNLOCK, this.forcedUnlock);
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.ERROR, this.error.getEventCount());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.STATE_ERROR, this.stateError.getEventCount());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_ERROR, this.error.getLastEventAt());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_STATE_ERROR, this.stateError.getLastEventAt());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_LOCK, this.lock.getLastEventAt());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_UNLOCK, this.unlock.getLastEventAt());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_RENEWAL, this.lastRenewalAt.get());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_ACCESS, LongStream.of(this.lock.getLastEventAt(), this.lastRenewalAt.get(), this.unlock.getLastEventAt(), this.error.getLastEventAt(), this.stateError.getLastEventAt(), this.failByRemote.getLastEventAt()).max().getAsLong());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.SUCCESSFUL_LOCKS, this.lock.getEventCount());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.SUCCESSFUL_UNLOCKS, this.unlock.getEventCount());
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.WAIT_QUEUE_LENGTH, this.waitQueueLength);
        StatisticsHolder.addAverageStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.AVERAGE_HOLD_TIME_MILLIS, this.totalHoldTimeMillis, this.unlock.getEventCount());
        StatisticsHolder.addAverageStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.AVERAGE_WAIT_TIME_MILLIS, this.totalWaitTimeMillis, this.totalWaits);
        return stats.build();
    }

    void tallyLockedAt(long currentTimeMillis) {
        this.lock.onEvent(currentTimeMillis);
    }

    void tallyWaitBegin() {
        this.waitQueueLength.incrementAndGet();
    }

    void tallyWaitEndAfter(long durationInMillis) {
        this.waitQueueLength.decrementAndGet();
        if (durationInMillis > 0L) {
            this.totalWaitTimeMillis.addAndGet(durationInMillis);
        }
        this.totalWaits.incrementAndGet();
    }

    private static void addStat(ImmutableMap.Builder<StatisticsKey, Long> stats, StatisticsKey key, Number valueHolder) {
        long value = valueHolder.longValue();
        if (value > 0L) {
            stats.put((Object)key, (Object)value);
        }
    }

    void tallyRenewed(long timestamp) {
        this.lastRenewalAt.set(timestamp);
    }

    void tallyUnlockedAt(long timestamp) {
        long since = this.lock.getLastEventAt();
        this.unlock.onEvent(timestamp);
        if (timestamp > since) {
            this.totalHoldTimeMillis.addAndGet(timestamp - since);
        }
    }

    private static class StatEvent {
        private final AtomicLong lastEventAt = new AtomicLong();
        private final AtomicLong eventCount = new AtomicLong();

        private StatEvent() {
        }

        public long getEventCount() {
            return this.eventCount.get();
        }

        public long getLastEventAt() {
            return this.lastEventAt.get();
        }

        public void onEvent(Long timestamp) {
            this.lastEventAt.set(timestamp);
            this.eventCount.incrementAndGet();
        }
    }
}

