/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.db;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.core.LockRegistry;
import com.atlassian.beehive.core.ManagedClusterLockService;
import com.atlassian.beehive.db.DatabaseClusterLock;
import com.atlassian.beehive.db.DatabaseClusterLockLeaseRenewer;
import com.atlassian.beehive.db.spi.ClusterLockDao;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;

public class DatabaseClusterLockService
implements ManagedClusterLockService {
    private final ClusterLockDao clusterLockDao;
    private final LockRegistry<DatabaseClusterLock> registry = new LockRegistry<DatabaseClusterLock>(){

        protected DatabaseClusterLock createLock(String lockName) {
            return new DatabaseClusterLock(lockName, DatabaseClusterLockService.this.clusterLockDao, DatabaseClusterLockService.this.databaseClusterLockLeaseRenewer);
        }
    };
    private final DatabaseClusterLockLeaseRenewer databaseClusterLockLeaseRenewer;

    public DatabaseClusterLockService(ClusterLockDao clusterLockDao) {
        this.clusterLockDao = clusterLockDao;
        this.databaseClusterLockLeaseRenewer = new DatabaseClusterLockLeaseRenewer(clusterLockDao);
        clusterLockDao.releaseLocksHeldByNode();
    }

    public Collection<DatabaseClusterLock> getAllKnownClusterLocks() {
        return this.registry.getAllKnownClusterLocks();
    }

    @Nonnull
    public Collection<ClusterLockStatus> getStatusesOfAllHeldClusterLocks() {
        return this.clusterLockDao.getAllHeldClusterLocks();
    }

    public ClusterLock getLockForName(@Nonnull String lockName) {
        return this.registry.getLockForName(lockName);
    }

    @PreDestroy
    public void shutdown() {
        this.databaseClusterLockLeaseRenewer.shutdown();
    }
}

