package com.atlassian.beehive.core;

import javax.annotation.Nonnull;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;

import static java.util.Objects.requireNonNull;

/**
 * A cluster lock service that delegates all requests to another cluster lock service.
 * <p>
 * The intended purpose is to allow applications to instantiate a {@link ManagedClusterLockService}
 * visible only to the application and register this restricted implementation as
 * the {@link ClusterLockService} that is available to add-ons.
 * </p>
 *
 * @since v0.2
 */
public class DelegatingClusterLockService implements ClusterLockService
{
    private final ClusterLockService delegate;

    public DelegatingClusterLockService(ClusterLockService delegate)
    {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    @Override
    public ClusterLock getLockForName(@Nonnull String lockName)
    {
        return delegate.getLockForName(lockName);
    }
}
