package com.atlassian.beehive.core.stats;

/**
 * The type of statistic that a {@link StatisticsKey} represents.
 * <p>
 * The different types of statistics have different underlying meanings and might be represented
 * differently in a management user interface.
 * </p>
 *
 * @since v0.2
 */
public enum StatisticsType
{
    /**
     * A statistic that counts the number of times an event has occurred, such as the number of
     * times that a given lock has been acquired.
     * <p>
     * Statistics of this type should strictly increase in value, as they represent a tally
     * of events that have already occurred, not a currently measured value.
     * </p>
     */
    COUNTER,

    /**
     * A statistic that represents something that represents a varying measurement, such as the
     * number of threads that are currently waiting to acquire a given lock.
     * <p>
     * Statistics of this type may either increase or decrease over time, as they represent a
     * currently measure value, not a tally of discrete events.
     * </p>
     */
    GAUGE
}
