package com.atlassian.beehive.core;

import java.util.Map;

import javax.annotation.Nonnull;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.core.stats.StatisticsKey;

/**
 * Decorates a cluster lock with management concerns, such as its name and statistics.
 *
 * @since v0.2
 */
public interface ManagedClusterLock extends ClusterLock
{
    /**
     * Returns the name of this cluster lock.
     * This is the same name that was supplied to {@link com.atlassian.beehive.ClusterLockService#getLockForName(String)}.
     *
     * @return the name of this cluster lock.
     */
    @Nonnull
    String getName();

    /**
     * @return {@code true} if any thread on any node holds this lock and
     *         {@code false} otherwise
     */
    boolean isLocked();

    /**
     * Returns the currently available statistics for this lock.
     * <p>
     * Callers should generally make no assumptions about what statistics are available or what they mean,
     * and this is likely to vary with the implementation.
     * </p>
     *
     * @return a map of statistics keys to their values, in no particular order
     */
    @Nonnull
    Map<StatisticsKey,Long> getStatistics();

    /**
     * Returns the status of this lock.
     * <p>
     * Callers must be aware that not all implementations can return a valid update time of the lock.
     * </p>
     *
     * @return a {@link com.atlassian.beehive.core.ClusterLockStatus} for this lock
     */
    @Nonnull
    ClusterLockStatus getClusterLockStatus();
}
