/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.core.stats;

import com.atlassian.beehive.core.stats.StatisticsType;
import java.util.Comparator;

public enum StatisticsKey {
    AVERAGE_HOLD_TIME_MILLIS("averageHoldTimeMillis", StatisticsType.GAUGE),
    AVERAGE_WAIT_TIME_MILLIS("averageWaitTimeMillis", StatisticsType.GAUGE),
    FAIL_LOCAL("failLocal", StatisticsType.COUNTER),
    FAIL_REMOTE("failRemote", StatisticsType.COUNTER),
    LAST_FAIL_REMOTE("lastFailRemote", StatisticsType.COUNTER),
    LAST_STATE_ERROR("lastStateError", StatisticsType.COUNTER),
    STATE_ERROR("failByStateError", StatisticsType.COUNTER),
    LAST_ERROR("lastError", StatisticsType.COUNTER),
    ERROR("failByError", StatisticsType.COUNTER),
    LAST_ACCESS("lastAccess", StatisticsType.GAUGE),
    LAST_LOCK("lastLock", StatisticsType.GAUGE),
    LAST_UNLOCK("lastUnlock", StatisticsType.GAUGE),
    LAST_RENEWAL("lastRenewal", StatisticsType.GAUGE),
    FORCED_UNLOCK("forcedUnlock", StatisticsType.COUNTER),
    SUCCESSFUL_LOCKS("lockSuccess", StatisticsType.COUNTER),
    SUCCESSFUL_UNLOCKS("unlockSuccess", StatisticsType.COUNTER),
    WAIT_QUEUE_LENGTH("waitQueueLength", StatisticsType.GAUGE);

    public static Comparator<StatisticsKey> SORT_BY_LABEL;
    private final String label;
    private final StatisticsType type;

    private StatisticsKey(String label, StatisticsType type) {
        this.label = label;
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public StatisticsType getType() {
        return this.type;
    }

    static {
        SORT_BY_LABEL = new Comparator<StatisticsKey>(){

            @Override
            public int compare(StatisticsKey key1, StatisticsKey key2) {
                return key1.getLabel().compareTo(key2.getLabel());
            }
        };
    }
}

