/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.beehive.ClusterNodeHeartbeatService;
import com.atlassian.beehive.DatabaseClusterLock;
import com.atlassian.beehive.spi.ClusterLockDao;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;

public class DatabaseClusterLockService
implements ClusterLockService {
    private final ConcurrentMap<String, ClusterLock> lockMap = new ConcurrentHashMap<String, ClusterLock>();
    private final ClusterLockDao clusterLockDao;
    private final ClusterNodeHeartbeatService clusterNodeHeartbeatService;

    public DatabaseClusterLockService(ClusterLockDao clusterLockDao, ClusterNodeHeartbeatService clusterNodeHeartbeatService) {
        this.clusterLockDao = clusterLockDao;
        this.clusterNodeHeartbeatService = clusterNodeHeartbeatService;
    }

    @PostConstruct
    public void cleanUpOrphanLocks() {
        this.clusterLockDao.deleteLocksHeldByNode(this.clusterNodeHeartbeatService.getNodeId());
    }

    public ClusterLock getLockForName(@Nonnull String lockName) {
        ClusterLock lock = (ClusterLock)this.lockMap.get(lockName);
        if (lock != null) {
            return lock;
        }
        this.lockMap.putIfAbsent(lockName, new DatabaseClusterLock(lockName, this.clusterLockDao, this.clusterNodeHeartbeatService));
        return (ClusterLock)this.lockMap.get(lockName);
    }
}

