/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.hockeyapp;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadTaskConfigurator
extends AbstractTaskConfigurator {
    private TextProvider textProvider;
    private static final String CFG_API_TOKEN = "apitoken";
    private static final String CFG_DOWNLOAD = "download";
    private static final String CFG_DSYM = "dsym";
    private static final String CFG_IPA = "ipa";
    private static final String CFG_NOTES = "notes";
    private static final String CFG_NOTES_TYPE = "notes_type";
    private static final String CFG_NOTIFY = "notify";
    private static final String CFG_TAGS = "tags";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"apitoken", (Object)"download", (Object)"dsym", (Object)"ipa", (Object)"notes", (Object)"notes_type", (Object)"notify", (Object)"tags");

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, FIELDS_TO_COPY);
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String ipa;
        super.validate(params, errorCollection);
        String apiToken = params.getString(CFG_API_TOKEN);
        if (StringUtils.isEmpty((String)apiToken)) {
            errorCollection.addError(CFG_API_TOKEN, this.textProvider.getText("hockey.apitoken.error"));
        }
        if (StringUtils.isEmpty((String)(ipa = params.getString(CFG_IPA)))) {
            errorCollection.addError(CFG_IPA, this.textProvider.getText("hockey.ipa.error"));
        }
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

