/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FastlaneConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport {
    protected static final String FASTLANE_LANE_ERROR_KEY = "fastlane.lane.error";
    public static final String FASTLANE_LANE = "lane";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"lane", (Object)"workingSubDirectory", (Object)"label", (Object)"environmentVariables");
    private static final String CTX_UI_CONFIG_SUPPORT = "uiConfigSupport";
    private final TextProvider textProvider;
    private final UIConfigSupport uiConfigSupport;

    public FastlaneConfigurator(@ComponentImport TextProvider textProvider, @ComponentImport UIConfigSupport uiConfigSupport, @ComponentImport TaskConfiguratorHelper taskConfiguratorHelper) {
        this.uiConfigSupport = uiConfigSupport;
        this.taskConfiguratorHelper = taskConfiguratorHelper;
        this.textProvider = textProvider;
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, FIELDS_TO_COPY);
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        this.taskConfiguratorHelper.validateBuilderLabel(params, errorCollection);
        String lane = params.getString(FASTLANE_LANE);
        if (StringUtils.isBlank((CharSequence)lane)) {
            errorCollection.addError(FASTLANE_LANE, this.textProvider.getText(FASTLANE_LANE_ERROR_KEY));
        }
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        HashSet requirements = Sets.newHashSet();
        this.taskConfiguratorHelper.addSystemRequirementFromConfiguration((Set)requirements, taskDefinition, "label", "system.builder.fastlane");
        return requirements;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForAllOperations(context);
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
    }
}

