/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.TaggingAwareRepository;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.AbstractRepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsTaggingTaskConfigurator
extends AbstractRepositoryAwareTaskConfigurator
implements RepositoryAwareTaskConfigurator {
    private static final Logger log = Logger.getLogger(VcsTaggingTaskConfigurator.class);
    public static final String CFG_TAG_NAME = "tagName";
    public static final String CFG_SELECTED_REPOSITORY = "selectedRepository";
    public static final String CFG_DEFAULT_REPOSITORY = "defaultRepository";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"tagName", (Object)"selectedRepository");
    private static final String CTX_REPOSITORY_TAGGING_SUPPORTED = "taggingSupported";
    private static final String CTX_SUPPORTED_REPOSITORIES = "supportedRepositories";
    private static final String CTX_REPOSITORY_SELECTION = "repositories";
    private static final String DEFAULT_TAG_NAME = "${bamboo.buildResultKey}";

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        boolean branchingSupported;
        boolean bl = branchingSupported = !this.getSupportedRepositoriesFromPlan(context).isEmpty();
        if (branchingSupported) {
            this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        }
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        boolean branchingSupported;
        boolean bl = branchingSupported = !this.getSupportedRepositoriesFromPlan(context).isEmpty();
        if (branchingSupported) {
            this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        }
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        Map<String, String> repositorySelection = this.getSupportedRepositoriesFromPlan(context);
        if (!repositorySelection.isEmpty()) {
            context.put(CFG_TAG_NAME, DEFAULT_TAG_NAME);
            context.put(CFG_SELECTED_REPOSITORY, Iterables.getFirst(repositorySelection.keySet(), (Object)""));
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (params.getBoolean(CTX_REPOSITORY_TAGGING_SUPPORTED)) {
            if (StringUtils.isEmpty((String)params.getString(CFG_TAG_NAME))) {
                errorCollection.addError(CFG_TAG_NAME, this.textProvider.getText("vcs.tagging.tag.name.mandatory"));
            }
        } else {
            errorCollection.addError("_a_", this.textProvider.getText("vcs.tagging.unsupported.repository"));
        }
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        HashMap config = Maps.newHashMap();
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters((Map)config, params, FIELDS_TO_COPY);
        return config;
    }

    private Map<String, String> getSupportedRepositoriesFromPlan(@NotNull Map<String, Object> context) {
        LinkedHashMap repositoryMap = Maps.newLinkedHashMap();
        ImmutablePlan plan = (ImmutablePlan)context.get("plan");
        List repositoryDefinitions = PlanHelper.getRepositoryDefinitions((ImmutablePlan)plan);
        boolean firstTime = true;
        for (RepositoryDefinition repositoryDefinition : repositoryDefinitions) {
            Repository repository = repositoryDefinition.getRepository();
            if (repository instanceof TaggingAwareRepository) {
                if (firstTime) {
                    context.put("defaultRepositoryKey", CFG_DEFAULT_REPOSITORY);
                }
                repositoryMap.put(Long.toString(repositoryDefinition.getId()), repositoryDefinition.getName());
            }
            firstTime = false;
        }
        if (repositoryMap.isEmpty()) {
            context.put(CTX_REPOSITORY_TAGGING_SUPPORTED, Boolean.FALSE);
            List repositories = this.repositoryManager.getRepositories();
            ArrayList supportedRepos = Lists.newArrayList();
            for (Repository r : repositories) {
                if (!(r instanceof TaggingAwareRepository)) continue;
                supportedRepos.add(r.getName());
            }
            context.put(CTX_SUPPORTED_REPOSITORIES, supportedRepos);
        }
        context.put(CTX_REPOSITORY_SELECTION, repositoryMap);
        context.put(CTX_REPOSITORY_TAGGING_SUPPORTED, !repositoryMap.isEmpty());
        return repositoryMap;
    }
}

