/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.AbstractRepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCheckoutTaskConfigurator
extends AbstractRepositoryAwareTaskConfigurator
implements RepositoryAwareTaskConfigurator {
    private static final Logger log = Logger.getLogger(VcsCheckoutTaskConfigurator.class);
    public static final String CFG_SELECTED_REPOSITORIES_INDICES = "selectedRepositoriesIndices";
    public static final String CFG_SELECTED_REPOSITORY_ID_PREFIX = "selectedRepository_";
    public static final String CFG_DEFAULT_REPOSITORY = "defaultRepository";
    public static final String CFG_CHECKOUT_DIR_PREFIX = "checkoutDir_";
    public static final String CFG_CLEAN_CHECKOUT = "cleanCheckout";
    private static final String CTX_REPOSITORY_SELECTION = "repositories";
    private static final String CTX_CUSTOM_SOURCE_DIR_AWARE = "customWorkingDirectoryAwareRepositories";
    private static final String CTX_USING_LEGACY_SOURCE_DIRECTORY = "repositoriesUsingLegacySourceDirectory";

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        this.populateContextForAllOperations(context);
        context.putAll(taskDefinition.getConfiguration());
        this.generateSelectedRepositoriesList(context, taskDefinition);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        this.populateContextForAllOperations(context);
        context.putAll(taskDefinition.getConfiguration());
        this.generateSelectedRepositoriesList(context, taskDefinition);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        this.populateContextForAllOperations(context);
        context.put("selectedRepository_0", CFG_DEFAULT_REPOSITORY);
        context.put(CFG_SELECTED_REPOSITORIES_INDICES, Lists.newArrayList((Object[])new Integer[]{0}));
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        LinkedHashMap repositoryMap = Maps.newLinkedHashMap();
        StringBuilder customSourceDirAwares = new StringBuilder();
        StringBuilder usingLegacySourceDirectory = new StringBuilder();
        if (context.containsKey("deploymentMode") && ((Boolean)context.get("deploymentMode")).booleanValue()) {
            for (RepositoryData repositoryDefinition : this.repositoryDefinitionManager.getGlobalRepositoryDefinitions()) {
                Repository repository = repositoryDefinition.getRepository();
                String idString = Long.toString(repositoryDefinition.getId());
                if (!(repository instanceof DeploymentAwareRepository)) continue;
                if (repository instanceof CustomSourceDirectoryAwareRepository) {
                    customSourceDirAwares.append(idString);
                    customSourceDirAwares.append(" ");
                } else {
                    usingLegacySourceDirectory.append(idString);
                    usingLegacySourceDirectory.append(" ");
                }
                repositoryMap.put(idString, repositoryDefinition.getName());
            }
            context.put(CTX_REPOSITORY_SELECTION, repositoryMap);
            context.put(CTX_CUSTOM_SOURCE_DIR_AWARE, customSourceDirAwares.toString());
            context.put(CTX_USING_LEGACY_SOURCE_DIRECTORY, usingLegacySourceDirectory.toString());
        } else {
            ImmutablePlan plan = (ImmutablePlan)context.get("plan");
            List repositoryDefinitions = PlanHelper.getRepositoryDefinitions((ImmutablePlan)plan);
            boolean firstTime = true;
            for (RepositoryDefinition repositoryDefinition : repositoryDefinitions) {
                Repository repository = repositoryDefinition.getRepository();
                String idString = Long.toString(repositoryDefinition.getId());
                if (repository instanceof CustomSourceDirectoryAwareRepository) {
                    customSourceDirAwares.append(idString);
                    customSourceDirAwares.append(" ");
                    if (firstTime) {
                        customSourceDirAwares.append(CFG_DEFAULT_REPOSITORY);
                        customSourceDirAwares.append(" ");
                    }
                } else {
                    usingLegacySourceDirectory.append(idString);
                    usingLegacySourceDirectory.append(" ");
                    if (firstTime) {
                        usingLegacySourceDirectory.append(CFG_DEFAULT_REPOSITORY);
                        usingLegacySourceDirectory.append(" ");
                    }
                }
                repositoryMap.put(idString, repositoryDefinition.getName());
                firstTime = false;
            }
            context.put(CTX_REPOSITORY_SELECTION, repositoryMap);
            context.put("defaultRepositoryKey", CFG_DEFAULT_REPOSITORY);
            if (repositoryDefinitions.iterator().hasNext()) {
                context.put("defaultRepositoryName", ((RepositoryDefinition)repositoryDefinitions.iterator().next()).getName());
            } else {
                context.put("defaultRepositoryName", this.textProvider.getText("repository.no.default"));
            }
            context.put(CTX_CUSTOM_SOURCE_DIR_AWARE, customSourceDirAwares.toString());
            context.put(CTX_USING_LEGACY_SOURCE_DIRECTORY, usingLegacySourceDirectory.toString());
        }
    }

    private void generateSelectedRepositoriesList(Map<String, Object> context, TaskDefinition taskDefinition) {
        ArrayList selectedRepositoriesList = Lists.newArrayList();
        for (String key : Iterables.filter(taskDefinition.getConfiguration().keySet(), (Predicate)BambooPredicates.startsWith((String)CFG_SELECTED_REPOSITORY_ID_PREFIX))) {
            selectedRepositoriesList.add(Integer.valueOf(StringUtils.removeStart((String)key, (String)CFG_SELECTED_REPOSITORY_ID_PREFIX)));
        }
        context.put(CFG_SELECTED_REPOSITORIES_INDICES, selectedRepositoriesList);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        for (String key : Iterables.filter((Iterable)params.keySet(), (Predicate)BambooPredicates.startsWith((String)CFG_CHECKOUT_DIR_PREFIX))) {
            String checkoutDir = params.getString(key);
            if (BambooFilenameUtils.doesPathFollowToParentDirectory((String)checkoutDir)) {
                errorCollection.addError(key, this.textProvider.getText("vcs.checkout.directory.parent.forbidden"));
            }
            if (!BambooFilenameUtils.isPathAbsolute((String)checkoutDir)) continue;
            errorCollection.addError(key, this.textProvider.getText("vcs.checkout.directory.absolute.forbidden"));
        }
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        HashMap config = Maps.newHashMap();
        config.put(CFG_CLEAN_CHECKOUT, params.getString(CFG_CLEAN_CHECKOUT));
        for (String key : params.keySet()) {
            if (!key.startsWith(CFG_SELECTED_REPOSITORY_ID_PREFIX) && !key.startsWith(CFG_CHECKOUT_DIR_PREFIX)) continue;
            config.put(key, params.getString(key));
        }
        return config;
    }
}

