/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.branch.BranchIntegrationHelper;
import com.atlassian.bamboo.plan.branch.MergeResult;
import com.atlassian.bamboo.plugins.vcs.task.DeploymentRepositoryBuildContext;
import com.atlassian.bamboo.repository.AbstractRepository;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.MandatoryCleanCheckoutAwareRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.PreparationTask;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.LegacyRepository;
import com.atlassian.bamboo.v2.build.repository.RepositoryEventAware;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.v2.trigger.DefaultChangeDetectionManager;
import com.atlassian.fugue.Pair;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCheckoutTask
implements CommonTaskType,
PreparationTask {
    private static final Logger log = Logger.getLogger(VcsCheckoutTask.class);
    private static final int MAX_RETRIES = DefaultChangeDetectionManager.MAX_OPERATION_RETRIES;
    private BranchIntegrationHelper branchIntegrationHelper;

    public VcsCheckoutTask(BranchIntegrationHelper branchIntegrationHelper) {
        this.branchIntegrationHelper = branchIntegrationHelper;
    }

    @NotNull
    public TaskResult execute(final @NotNull CommonTaskContext taskContext) throws TaskException {
        RepositoryEventAware repositoryEventAware;
        File sourceDirectory;
        Repository repository;
        RepositoryDefinition repositoryToCheckout;
        String checkoutDirectory;
        BuildContext buildContext;
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        boolean deploymentMode = false;
        CommonContext commonContext = taskContext.getCommonContext();
        if (Narrow.to((Object)commonContext, BuildContext.class) == null) {
            deploymentMode = true;
            buildContext = new DeploymentRepositoryBuildContext(commonContext);
        } else {
            buildContext = (BuildContext)Narrow.to((Object)commonContext, BuildContext.class);
        }
        BuildLogger buildLogger = taskContext.getBuildLogger();
        final boolean cleanCheckout = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"cleanCheckout"));
        ArrayList repositoriesToCheckout = Lists.newArrayList();
        for (String key : Iterables.filter((Iterable)taskContext.getConfigurationMap().keySet(), (Predicate)RepositoryTaskHelper.isRepositorySelector)) {
            String indexString = key.substring("selectedRepository_".length());
            checkoutDirectory = (String)taskContext.getConfigurationMap().get((Object)("checkoutDir_" + indexString));
            try {
                RepositoryDefinition repositoryToCheckout2 = RepositoryTaskHelper.getRepositoryDefinitionByIdSelector((CommonTaskContext)taskContext, (String)key);
                repositoriesToCheckout.add(Pair.pair((Object)repositoryToCheckout2, (Object)checkoutDirectory));
            }
            catch (RepositoryDefinitionException e) {
                throw new TaskException("Error while updating source", (Throwable)e);
            }
        }
        for (Pair pair : repositoriesToCheckout) {
            repositoryToCheckout = (RepositoryDefinition)pair.left();
            checkoutDirectory = (String)pair.right();
            repository = repositoryToCheckout.getRepository();
            sourceDirectory = this.getCheckoutDirectory(taskContext, checkoutDirectory);
            if (repository instanceof RepositoryEventAware) {
                log.info((Object)buildLogger.addBuildLogEntry("Running preRetrieveSourceCode task..."));
                repositoryEventAware = (RepositoryEventAware)repository;
                try {
                    repositoryEventAware.preRetrieveSourceCode(buildContext, sourceDirectory);
                }
                catch (AbstractMethodError e) {
                    log.info((Object)"Repository does not support checkout to subdirectory, falling back to the old method");
                    repositoryEventAware.preRetrieveSourceCode(buildContext);
                }
            }
            try {
                this.cleanWorkingDirIfNeeded(checkoutDirectory, (RepositoryV2)repository, taskContext, cleanCheckout);
            }
            catch (Exception e) {
                RetryingTaskExecutor.retry((String)("Cleaning directory for " + commonContext.getDisplayName()), (int)MAX_RETRIES, (long)((long)(Math.random() * 1000.0)), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        VcsCheckoutTask.this.cleanWorkingDirIfNeeded(checkoutDirectory, (RepositoryV2)repository, taskContext, cleanCheckout);
                        return null;
                    }
                });
            }
        }
        for (Pair pair : repositoriesToCheckout) {
            repositoryToCheckout = (RepositoryDefinition)pair.left();
            checkoutDirectory = (String)pair.right();
            repository = repositoryToCheckout.getRepository();
            sourceDirectory = this.getCheckoutDirectory(taskContext, checkoutDirectory);
            try {
                this.fillWorkingDirFromVcs(repositoryToCheckout.getId(), PlanHelper.isDefault((RepositoryDefinition)repositoryToCheckout), checkoutDirectory, (RepositoryV2)repository, taskContext, buildContext);
            }
            catch (Exception e) {
                RetryingTaskExecutor.retry((String)("Retrieving source for " + commonContext.getDisplayName()), (int)MAX_RETRIES, (long)((long)(Math.random() * 1000.0)), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        VcsCheckoutTask.this.fillWorkingDirFromVcs(repositoryToCheckout.getId(), PlanHelper.isDefault((RepositoryDefinition)repositoryToCheckout), checkoutDirectory, (RepositoryV2)repository, taskContext, buildContext);
                        return null;
                    }
                });
            }
            if (!deploymentMode) {
                buildContext.getCheckoutLocation().put(repositoryToCheckout.getId(), sourceDirectory.getAbsolutePath());
            }
            if (!(repository instanceof RepositoryEventAware)) continue;
            log.info((Object)buildLogger.addBuildLogEntry("Running postRetrieveSourceCode task..."));
            repositoryEventAware = (RepositoryEventAware)repository;
            try {
                repositoryEventAware.postRetrieveSourceCode(buildContext, sourceDirectory);
            }
            catch (AbstractMethodError e) {
                log.info((Object)"Repository does not support checkout to subdirectory, falling back to the old method");
                repositoryEventAware.postRetrieveSourceCode(buildContext);
            }
        }
        return taskResultBuilder.success().build();
    }

    private File getCheckoutDirectory(@NotNull CommonTaskContext taskContext, @NotNull String checkoutDir) {
        File sourceCodeDir = new File(taskContext.getRootDirectory(), checkoutDir);
        sourceCodeDir.mkdirs();
        return sourceCodeDir;
    }

    private void fillWorkingDirFromVcs(long repositoryId, boolean isDefaultRepository, String checkoutDir, RepositoryV2 repository, CommonTaskContext taskContext, BuildContext buildContext) throws RepositoryException {
        CommonContext commonContext = taskContext.getCommonContext();
        DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)Narrow.to((Object)taskContext, DeploymentTaskContext.class);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        if (deploymentTaskContext == null) {
            String vcsRevisionKey;
            boolean isBranchIntegrationEnabled;
            BranchMergingAwareRepository mergeCapableRepository = AbstractRepository.toMergeCapableRepository((RepositoryV2)repository);
            boolean bl = isBranchIntegrationEnabled = isDefaultRepository && buildContext.getBuildDefinition().getBranchIntegrationConfiguration().isEnabled();
            if (isBranchIntegrationEnabled && mergeCapableRepository == null) {
                throw new IllegalArgumentException("Branch integration enabled on a repository that does not support merging");
            }
            String targetRevision = buildContext.getBuildChanges().getVcsRevisionKey(repositoryId);
            if (isBranchIntegrationEnabled) {
                BuildLogger logger = taskContext.getBuildLogger();
                MergeResult mergeResult = this.branchIntegrationHelper.merge(buildContext, this.getCheckoutDirectory(taskContext, checkoutDir), logger);
                vcsRevisionKey = mergeResult.getCheckoutRevision();
            } else {
                log.info((Object)buildLogger.addBuildLogEntry("Updating source code to revision: " + targetRevision));
                CustomSourceDirectoryAwareRepository customSourceDirectoryAwareRepository = (CustomSourceDirectoryAwareRepository)Narrow.to((Object)repository, CustomSourceDirectoryAwareRepository.class);
                if (customSourceDirectoryAwareRepository != null) {
                    vcsRevisionKey = customSourceDirectoryAwareRepository.retrieveSourceCode(buildContext, targetRevision, this.getCheckoutDirectory(taskContext, checkoutDir));
                } else {
                    LegacyRepository legacyRepository = (LegacyRepository)Narrow.to((Object)repository, LegacyRepository.class);
                    if (legacyRepository != null) {
                        log.info((Object)"Repository does not support checkout to subdirectory, falling back to the old method");
                        vcsRevisionKey = legacyRepository.retrieveSourceCode(buildContext, targetRevision);
                    } else {
                        throw new IllegalArgumentException("Repository doesn't implement neither CustomSourceDirectoryAwareRepository nor LegacyRepository interface - checkout is not possible");
                    }
                }
            }
            buildContext.getBuildChanges().setVcsRevisionKey(repositoryId, vcsRevisionKey);
            buildContext.getBuildResult().setCheckoutSuccess(true);
            log.info((Object)buildLogger.addBuildLogEntry("Updated source code to revision: " + vcsRevisionKey));
        } else {
            String vcsRevisionKey;
            BuildRepositoryChanges changes = repository.collectChangesSinceLastBuild(commonContext.getEntityKey().getKey(), null);
            String targetRevision = changes.getVcsRevisionKey();
            log.info((Object)buildLogger.addBuildLogEntry("Updating source code to revision: " + targetRevision));
            CustomSourceDirectoryAwareRepository customSourceDirectoryAwareRepository = (CustomSourceDirectoryAwareRepository)Narrow.to((Object)repository, CustomSourceDirectoryAwareRepository.class);
            if (customSourceDirectoryAwareRepository != null) {
                vcsRevisionKey = customSourceDirectoryAwareRepository.retrieveSourceCode(buildContext, targetRevision, this.getCheckoutDirectory(taskContext, checkoutDir));
            } else {
                LegacyRepository legacyRepository = (LegacyRepository)Narrow.to((Object)repository, LegacyRepository.class);
                if (legacyRepository != null) {
                    log.info((Object)"Repository does not support checkout to subdirectory, falling back to the old method");
                    vcsRevisionKey = legacyRepository.retrieveSourceCode(buildContext, targetRevision);
                } else {
                    throw new IllegalArgumentException("Repository doesn't implement neither CustomSourceDirectoryAwareRepository nor LegacyRepository interface - checkout is not possible");
                }
            }
            log.info((Object)buildLogger.addBuildLogEntry("Updated source code to revision: " + vcsRevisionKey));
        }
    }

    private void cleanWorkingDirIfNeeded(String checkoutDir, RepositoryV2 repository, CommonTaskContext taskContext, boolean cleanCheckout) throws RepositoryException {
        CommonContext commonContext = taskContext.getCommonContext();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String cleanBuildMessage = this.getCleanBuildMessage(repository, cleanCheckout);
        if (cleanBuildMessage != null) {
            log.info((Object)buildLogger.addBuildLogEntry(cleanBuildMessage));
            Key entityKey = commonContext.getResultKey().getEntityKey();
            PlanKey planKey = PlanKeys.getPlanKey((String)entityKey.getKey());
            CustomSourceDirectoryAwareRepository customSourceDirectoryAwareRepository = (CustomSourceDirectoryAwareRepository)Narrow.to((Object)repository, CustomSourceDirectoryAwareRepository.class);
            File planSourceDirectory = customSourceDirectoryAwareRepository != null ? this.getCheckoutDirectory(taskContext, checkoutDir) : repository.getSourceCodeDirectory(planKey);
            log.info((Object)buildLogger.addBuildLogEntry("Cleaning build directory '" + planSourceDirectory.getAbsolutePath() + "'"));
            if (BambooFileUtils.isDirectoryImportant((File)planSourceDirectory)) {
                String errorMessage = "A clean build cannot be forced for " + planKey + ", as the plan's source directory " + planSourceDirectory.getAbsolutePath() + " is reserved by the system. Please amend your build configuration.";
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage));
                throw new RepositoryException(errorMessage);
            }
            if (planSourceDirectory.exists()) {
                try {
                    FileUtils.cleanDirectory((File)planSourceDirectory);
                }
                catch (IOException e) {
                    String errorMessage = "Unable to clean source directory '" + planSourceDirectory.getAbsolutePath() + "' " + e.getMessage();
                    log.warn((Object)buildLogger.addErrorLogEntry(errorMessage), (Throwable)e);
                    throw new RepositoryException(errorMessage, (Throwable)e);
                }
            }
        }
    }

    @Nullable
    private String getCleanBuildMessage(RepositoryV2 repository, boolean cleanCheckout) {
        if (cleanCheckout) {
            return "Build always requires a clean checkout";
        }
        if (repository instanceof MandatoryCleanCheckoutAwareRepository && ((MandatoryCleanCheckoutAwareRepository)repository).isCleanCheckoutRequired()) {
            return "Clean checkout enforced by repository configuration";
        }
        return null;
    }
}

