/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.repository.BranchingAwareRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.util.Narrow;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VcsBranchingTask
implements TaskType {
    private static final Logger log = Logger.getLogger(VcsBranchingTask.class);

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String repositoryIdString = (String)taskContext.getConfigurationMap().get((Object)"selectedRepository");
        long repositoryId = repositoryIdString.equals("defaultRepository") ? ((RepositoryDefinition)taskContext.getBuildContext().getRepositoryDefinitions().iterator().next()).getId() : Long.parseLong(repositoryIdString);
        RepositoryDefinition repositoryToBranch = (RepositoryDefinition)taskContext.getBuildContext().getRepositoryDefinitionMap().get(repositoryId);
        if (repositoryToBranch == null) {
            throw new TaskException("Repository id " + repositoryId + " is invalid. Please reselect from the configuration screen.");
        }
        Repository repository = repositoryToBranch.getRepository();
        BranchingAwareRepository branchingAware = (BranchingAwareRepository)Narrow.to((Object)repository, BranchingAwareRepository.class);
        if (branchingAware != null) {
            try {
                String branchName = (String)taskContext.getConfigurationMap().get((Object)"branchName");
                branchingAware.createBranch(repositoryToBranch.getId(), branchName, taskContext.getBuildContext());
                return taskResultBuilder.build();
            }
            catch (Exception e) {
                throw new TaskException("Exception when branching repository", (Throwable)e);
            }
        }
        buildLogger.addErrorLogEntry("The branching of repository type '" + repository.getName() + "' is not supported");
        return taskResultBuilder.failed().build();
    }
}

